////////////////////////////////////////////////////////////////////////////////
// CPU.cpp -- this file is part of the Emulator Developers Kit
// available at http://ourworld.compuserve.com/homepages/pc64/develop.htm

RegisterPersistentClass(CPU);


////////////////////////////////////////////////////////////////////////////////
// a Chip is linked in after the clock (o2 low phase)
// a CPU is linked in before the clock (o2 high phase)

global void CPU::SetBusy() {

  // check conditions
  assert(!IsBusy());
  assert((CPU*)pClock != this);
  assert(pfnOnClock != NULL);

  // link CPU into the clock list
  if (pClock != NULL) {
    assert(((CPU*)((CPU*)pClock)->pNextChip)->pPrevChip == pClock);
    assert(((CPU*)((CPU*)pClock)->pPrevChip)->pNextChip == pClock);
    pPrevChip = ((CPU*)pClock)->pPrevChip;
    ((CPU*)((CPU*)pClock)->pPrevChip)->pNextChip = this;
    pNextChip = (CPU*)pClock;
    ((CPU*)pClock)->pPrevChip = this;
  }

  // set busy flag
  fBusy = true;
}
