////////////////////////////////////////////////////////////////////////////////
// Win32/EDK.h -- this file is part of the Emulator Developers Kit
// available at http://ourworld.compuserve.com/homepages/pc64/develop.htm
//
// Includes the EDK component headers.

#include <Toolbox.h>


////////////////////////////////////////////////////////////////////////////////
// define global linkage for the EDK components
// use /D "ExportEDK" and /D "ImportEDK" if the code resides in a DLL

#if defined(EDK_cpp) && defined(ExportEDK)
  #define global __declspec(dllexport)
#elif defined(ImportEDK)
  #define global __declspec(dllimport)
#else
  #define global
#endif


////////////////////////////////////////////////////////////////////////////////
// include the platform independent components from the EDK main directory

#include "../Object.h"
#include "../Line.h"
#include "../Port.h"
#include "../Timer.h"
#include "../Chip.h"
#include "../Clock.h"
#include "../CPU.h"
#include "../CPU16x4k.h"
#include "../CPU65xx.h"
#include "../CPU6502.h"
#include "../CPU6510C64.h"
#include "../CIA6526.h"
#include "../SID6581.h"

// TODO: delete this when the C64 class has been included here
#if defined(ImportEDK)
  #define C64 CC64
  class CC64 : public Chip {
  public:
    global void MapROM8000(byte* pbROM);
    global void UnmapROM8000();
    global void MapROMA000(byte* pbROM);
    global void UnmapROMA000();
    global byte* GetBasic();
    global byte* GetKernal();
    global byte* GetCharset();
    global byte* GetIO();
    global byte* GetRAM();
    global Clock* GetClock();
  };
#endif


////////////////////////////////////////////////////////////////////////////////
// prevent unintentional use of the 'global' keyword in other files

#undef global
