#ifndef CC64File_h
#define CC64File_h

#include "CBMFileName.h"

class CC64File : public CBMFileName {
public:

  CString DosName;
  CString Directory;
  long lHeader;
  long lPosition;
  HANDLE hFile;
  byte* pbBuffer;
  int iIn;
  int iOut;

  void SetDOSError();
  void OpenFile();
  flag OpenExisting(const CString& Name);
  flag OpenOneExisting(const CString& Name);
  void CreateNew(const CString& Name);
  CString LongName();
  CString ShortName();
  void ReadDirectory();

  CC64File();
  virtual ~CC64File();
  void Open(const CString& Dir, const char* pcC64Name, int iLength = -1, int iChannel = 2);
  void Close();
  int Put(int iData);
  int Get();
  int Read(byte* pbDest, int iCount);
  int Write(const byte* pbSrc, int iCount);
};

#endif
