#include <EDK.h>
#include "General.h"
#include "CIECDevice.h"
#include "CHarddisk.h"
#include "CVC1541.h"
#include "CC64.h"


////////////////////////////////////////////////////////////////////////////////
// fastloading not supported by default

int CIECDevice::Load(CString Name, byte* /*pbBuffer*/, int /*iSize*/) {
  return 0;
}


////////////////////////////////////////////////////////////////////////////////
// constructor

CIECDevice::CIECDevice() {
  pfnListen = NULL;
  pfnListenCh = NULL;
  pfnReceive = NULL;
  pfnUnlisten = NULL;
  pfnTalk = NULL;
  pfnTalkCh = NULL;
  pfnSend = NULL;
  pfnUntalk = NULL;
}


////////////////////////////////////////////////////////////////////////////////
// device class factory

void SetDisk(CIECDevice** ppDevice, CString NewDisk) {

  DeviceType eOld = eNone;
  if (*ppDevice != NULL) {
    eOld = (*ppDevice)->GetType();
  }

  if (NewDisk.IsEmpty()) {
    if (eOld != eNone) {
      (*ppDevice)->SetDisk(NULL);
    }
    return;
  }
  
  DeviceType eNew = eHarddisk;
  if (NewDisk.Right(4).CompareNoCase(".d64") == 0) {
    eNew = eVC1541;
  }

  if (eOld != eNew) {

    if (*ppDevice != NULL) {
      delete *ppDevice;
      *ppDevice = NULL;
    }

    switch (eNew) {
    
    case eHarddisk:
      *ppDevice = new CHarddisk();
      break;

    case eVC1541:
      extern CC64* gpC64;
      *ppDevice = new CVC1541(8, &gpC64->IECMaster);
      break;

    }
  }

  (*ppDevice)->SetDisk(NewDisk);

}
