#ifndef CIECDevice_h
#define CIECDevice_h

#include "CLine.h"

#define DEVICE_NOT_PRESENT  0x8000
#define END_OF_FILE         0x4000
#define TIMEOUT_SEND        0x42C3
#define TIMEOUT_RECEIVE     0x0300

typedef enum {
  eNone, eHarddisk, eVC1541
} DeviceType;

class CIECDevice : public Chip {
public:

  CLine Reset;
  CLine ATN;
  CLine Clock;
  CLine Data;

  pfnv pfnListen;
  pfnv pfnListenCh;
  pfnv pfnReceive;
  pfnv pfnUnlisten;
  pfnv pfnTalk;
  pfnv pfnTalkCh;
  pfnv pfnSend;
  pfnv pfnUntalk;

  virtual int Load(CString Name, byte* pbBuffer, int iSize);

  virtual DeviceType GetType() = 0;
  virtual CString GetDisk() = 0;
  virtual void SetDisk(const CString& NewDisk) = 0;

  CIECDevice();
  virtual ~CIECDevice() {}
};

void SetDisk(CIECDevice** ppDevice, CString NewDisk);

#endif
