// This file is part of the Personal C64 Emulator Development Kit
// Copyright (C) 1995 by Wolfgang Lorenz 100112.220@compuserve.com
/*

A CMessage is a function which gets called when a message occurs. Examples
for messages are Start, Stop, Save, Load and WndProc. The latter allows an
extension to handle messages of the main window without having to use the
slow subclassing mechanism of Windows.

Messages are linked in a list. Parameters are passed in EAX. The handler
must restore EAX before it jumps to the next function in the list.

*/

#ifndef CMsg_h
#define CMsg_h

class CMsg : public Object {
public:
  pfnv pfnNext;              // event handler of next message
  Object* pNextObject;     // parent object of next message
  Object* pObject;         // object which contains this CMsg
  pfnv pfnOnMsg;             // event handler when message occurs
  CMsg();
  virtual ~CMsg();
};

class CSendMsg : public Object {
public:
  pfnv pfnNext;              // event handler of next message
  Object* pNextObject;     // parent object of next message
  CMsg* pLastMsg;           // last message in list
  CMsg* pFirstMsg;          // first message in list
  CSendMsg();
  virtual ~CSendMsg();
};

#define EndMsg(Msg) /* 7 */ \
  __asm mov EBX,Msg.pfnNext \
  __asm mov ThisReg,Msg.pNextObject \
  __asm jmp EBX

#define Send(SendMsg, Label) /* 10 */ \
  __asm mov EBX,SendMsg.pLastMsg \
  __asm mov ECX,SendMsg.pFirstMsg \
  __asm mov [EBX]CMsg.pfnNext,offset SendCont##Label \
  __asm mov [EBX]CMsg.pNextObject,ThisReg \
  __asm mov ThisReg,[ECX]CMsg.pNextObject \
  __asm jmp [ECX]CMsg.pfnNext \
  __asm align 4 \
  __asm SendCont##Label:

void Connect(CMsg& Msg, CSendMsg& Send);
void Disconnect(CMsg& Msg);

#endif
