#include <EDK.h>
#include "General.h"
#include "CVIC656x.h"

#define Class CVIC656x
extern Class MSVC4Bug;

/*
  CLine LP;             // light pen input
  byte bLPTriggered;    // trigger only once per frame
  byte bLPX;            // raster position when LP went low
  byte bLPY;
  byte abLPFill[1];
*/

proc(ResetLP)
  xor AL,AL
  mov mvar(bLPX),AL
  mov mvar(bLPY),AL
  mov mvar(bLPTriggered),AL
  ret
endp

proc(OnLPLow)
  push EBX
  push ThisReg
  mov ThisReg,ECX

  // trigger only once per frame
  cmp mvar(bLPTriggered),0
  jne Ignore
  mov mvar(bLPTriggered),1

  // get X position
  mov EBX,[ThisReg]Chip.pfnOnClock
  mov EBX,[EBX-4]
  sub BL,15
  shl BL,2
  mov mvar(bLPX),BL

  // get Y position
  mov AL,byte ptr mvar(iLine)
  mov mvar(bLPY),AL

  // set LP interrupt
  or mvar(bIRR),1000b
  test mvar(bIMR),1000b
  je Ignore
  SetLow(mvar(Int), 1)
Ignore:

  pop ThisReg
  pop EBX
  ret
endp

proc(ReadLPX)
  push ESI
  mov ESI,ECX

  mov AL,mvar(bLPX)

  pop ESI
  ret
endp

proc(ReadLPY)
  push ESI
  mov ESI,ECX

  mov AL,mvar(bLPY)

  pop ESI
  ret
endp
