#ifndef CC64_h
#define CC64_h

#include "CVIC656x.h"
#include "CIECMaster.h"
#include "CHarddisk.h"
#include "CPort.h"
#include "CKeyboard.h"
#include "CDisplay.h"

class CC64 : public Object {
public:

#ifdef ExportEDK
  #undef global
  #define global __declspec(dllexport)
#endif
  global void MapROM8000(byte* pbROM);
  global void UnmapROM8000();
  global void MapROMA000(byte* pbROM);
  global void UnmapROMA000();
  global byte* GetBasic();
  global byte* GetKernal();
  global byte* GetCharset();
  global byte* GetIO();
  global byte* GetRAM();
  global Clock* GetClock();
#undef global
#define global

  byte* pbRAM;              // 64K
  byte* pbKernal;           // 8K
  byte* pbBasic;            // 8K
  byte* pbCharset;          // 4K
  byte* pbIO;               // 4K
  CPU6510C64* pCPU;
  CVIC656x* pVIC;
  SID6581* pSID;
  CIA6526* pCIA1;
  CIA6526* pCIA2;
  byte* apbMapping8000R[8];
  byte* apbMappingA000R[8];
  byte* apbMappingD000R[8];
  byte* apbMappingD000W[8];
  byte* apbMappingE000R[8];
  CKeyboard Keyboard;
  Timer MainsFreq;
  void OnMainsFreq();
  CLine Mains;
  CLine Reset;
  CLine IRQ;
  CLine NMI;
  CPort VICBank;
  void OnVICBankChange(byte bState, byte bChanges);
  CPort Joystick;
  void OnJoystickChange(byte bState, byte bChanges);
  CPort SecondJoystick;
  void OnSecondJoystickChange(byte bState, byte bChanges);
  CPort Joy1;
  CPort Joy2;
  byte bSwapJoysticks;
  byte abFill[3];

  CPort MemMapping;
  void OnMemMappingChange(byte bState, byte bChanges);
  void InitMemMapping();
  void SetROMConfig(int iConfig);

  CDisplay Display;

  char* pcCopyright;    // string at $DEA0
  byte abVersion[4];    // version, 'P' and $55/$AA flipflop at $DEFC
  void InitCopyright();
  byte ReadCopyright();
  byte ReadVersion();

  CPort LPIn;
  void OnLPInChange(byte bState, byte bChanges);
  CLine LPOut;
  void InitLP();

  CIECMaster IECMaster; // target for Connect()
  CLine ATN;
  CLine Clock;
  CLine Data;
  CPort IECOut;         // ATN bit 3, Clock bit 4, Data bit 5
  void OnIECChange(byte bState, byte bChanges);
  byte bIECIn;          // Clock bit 6, Data bit 7
  byte abIECFill[3];
  void InitIEC();

  byte ReadColor();
  void WriteColor(byte bValue);

protected:

  // initialisation
  virtual void DoInit();

public:

  // constructor
  CC64();

  // destructor
  virtual ~CC64();

};

#endif
