#include <EDK.h>
#include "General.h"
#include "CC64.h"
                
#define Class CC64
extern Class MSVC4Bug;


void CC64::OnLPInChange(byte bState, byte bChanges) {
  __asm {
  push EBX
  push ThisReg
  mov ThisReg,this
  mov AL,bState
  mov AH,bChanges

  // has bit 4 changed?
  test AH,00010000b
  je NoChange
  // pass bit 4 to the LP line
  push EAX
  test AL,00010000b
  je DrawLow
  SetHigh(mvar(LPOut), 1)
  jmp Return
DrawLow:
  SetLow(mvar(LPOut), 1)
Return:
  pop EAX
NoChange:

  pop ThisReg
  pop EBX
  }
}

/*
  CPort LPIn;
  CLine LPOut;
  void InitLP();
*/

void CC64::InitLP() {
  LPIn.Init("LPIn", this);
  LPIn.SetOnChange((pfnbb)OnLPInChange);
  LPOut.Init("LPOut", this);
}
