#include <EDK.h>
#include "General.h"
#include "CC64.h"

#define Class CC64
extern Class MSVC4Bug;


/*
  char* pcCopyright;        // string at $DEA0
  byte abVersion[4];        // version, 'P' and $55/$AA flipflop at $DEFC
  void InitCopyright();
*/

void CC64::InitCopyright() {

  static char acCopyright[] = "Personal C64 " VERSION "\r(C)1994-1995 Wolfgang Lorenz";
  assert(sizeof acCopyright < 0xDEFC - 0xDEA0);
  _strupr(acCopyright);
  pcCopyright = acCopyright;

  byte bTrap = pCPU->AllocIOTrap(this, (bpfn)ReadCopyright, NULL);
  for (int i = 0; i < sizeof acCopyright; i++) {
    pCPU->SetTrap(pbIO + 0x0FA0 + i, bTrap);
  }

  abVersion[0] = (byte)(HEXVER & 0xFF);
  abVersion[1] = (byte)(HEXVER >> 8);
  abVersion[2] = (byte)'P';
  abVersion[3] = 0x55;

  bTrap = pCPU->AllocIOTrap(this, (bpfn)ReadVersion, NULL);
  for (i = 0; i < 4; i++) {
    pCPU->SetTrap(pbIO + 0x0FFC + i, bTrap);
  }

}

byte CC64::ReadCopyright() {
  return pcCopyright[pCPU->GetRWAddress() - 0xDEA0];
}

byte CC64::ReadVersion() {
  int iIndex = pCPU->GetRWAddress() - 0xDEFC;
  if (iIndex == 3) {
    abVersion[3] ^= 0xFF;
  }
  return abVersion[iIndex];
}
