#ifndef CVC1541_h
#define CVC1541_h

#include "CIECDevice.h"
#include "CIECMaster.h"
#include "CVIA6522.h"
#include "CFDC325572.h"
#include "CMsg.h"

class CVC1541 : public CIECDevice {
public:

  byte* pbRAM;          // 2 kb at $x000-$x7FF
  byte* pbIO;           // 4 kb at $1000-$1FFF
  byte* pbDummy;        // 4 kb for dummy reads and writes
  static byte* apbROM[4];// 16 kb Original.541 at $C000-$FFFF
  static int iROMRef;   // number of 1541 floppies with Original.541

  CPU6502* pCPU;        // 6502
  CVIA6522 VIA1;        // $1800 serial bus
  CVIA6522 VIA2;        // $1C00 drive control
  CFDC325572 FDC;       // floppy disk controller
  CLine IRQ;

  CLine NotATN;
  CPort IECOut;
  void OnIECChange(byte, byte);
  byte bIECIn;          // IEC address bits in PB 5-6
  byte abFiller[3];

  CPort Control;        // $1C00 drive control
  void OnControlChange(byte, byte);
  CLine Motor;          // PB2 drive motor, high = on
  CLine LED;            // PB3 drive LED, high = on
  CLine WPS;            // PB4 write protect switch, low = protected
  CSendMsg Clocks;      // PB5/PB6 speed control
  CLine Sync;           // PB7, low = SYNC
  CLine OE;
  byte bControlIn;
  byte abControlFill[3];

  Timer DiskChange;     // draws WPS low for 1 s
  void OnDiskChange();
  CLine WPSOut;         // unconnected lines can't have functions

  CLine Idle;           // halts CPU at $EBFF
  CLine IRQIdle;
  CLine ResetIdle;
  void InitIdle();
  void InitFormat();

  int Load(CString Name, byte* pbBuffer, int iSize);
  int Load(byte* pbTrack, int iTrack, int iSector, byte* pbBuffer, int iSize);
  int ReadTrack(int iTrack, byte* pbBuffer);

  DeviceType GetType();
  CString GetDisk();
  void SetDisk(const CString& NewDisk);

  CVC1541(int iDevice, CIECMaster* pIECMaster);
  virtual ~CVC1541();
};

#endif
