#include <EDK.h>
#include "General.h"

void DSError(HRESULT hError, char* pcFunction, char* pcFile, int iLine) {

  char* pcMsg = NULL;
  switch (hError) {

  case DSERR_ALLOCATED:
    pcMsg = "DSERR_ALLOCATED\nThe call failed because resources (such as a priority level) were already being used by another caller.";
    break;

  case DSERR_CONTROLUNAVAIL:
    pcMsg = "DSERR_CONTROLUNAVAIL\nThe control (vol,pan,etc.) requested by the caller is not available.";
    break;

  case DSERR_INVALIDPARAM:
    pcMsg = "DSERR_INVALIDPARAM\nAn invalid parameter was passed to the returning function";
    break;

  case DSERR_INVALIDCALL:
    pcMsg = "DSERR_INVALIDCALL\nThis call is not valid for the current state of this object";
    break;

  case DSERR_GENERIC:
    pcMsg = "DSERR_GENERIC\nAn undetermined error occured inside the DSound subsystem";
    break;

  case DSERR_PRIOLEVELNEEDED:
    pcMsg = "DSERR_PRIOLEVELNEEDED\nThe caller does not have the priority level required for the function to succeed.";
    break;

  case DSERR_OUTOFMEMORY:
    pcMsg = "DSERR_OUTOFMEMORY\nThe DSound subsystem couldn't allocate sufficient memory to complete the caller's request.";
    break;

  case DSERR_BADFORMAT:
    pcMsg = "DSERR_BADFORMAT\nThe specified WAVE format is not supported";
    break;

  case DSERR_UNSUPPORTED:
    pcMsg = "DSERR_UNSUPPORTED\nThe function called is not supported at this time";
    break;

  case DSERR_NODRIVER:
    pcMsg = "DSERR_NODRIVER\nNo sound driver is available for use";
    break;

  case DSERR_ALREADYINITIALIZED:
    pcMsg = "DSERR_ALREADYINITIALIZED\nThis object is already initialized";
    break;

  case DSERR_NOAGGREGATION:
    pcMsg = "DSERR_NOAGGREGATION\nThis object does not support aggregation";
    break;

  case DSERR_BUFFERLOST:
    pcMsg = "DSERR_BUFFERLOST\nThe buffer memory has been lost, and must be Restored.";
    break;

  case DSERR_OTHERAPPHASPRIO:
    pcMsg = "DSERR_OTHERAPPHASPRIO\nAnother app has a higher priority level, preventing this call from succeeding.";
    break;

  default:
    error("%s\nfailed in file %s at line %d\nUnknown DirectSound error %d", pcFunction, pcFile, iLine, hError);
  }
  error("%s\nfailed in file %s at line %d\n%s", pcFunction, pcFile, iLine, pcMsg);
}
