#include <EDK.h>
#include "General.h"
#include "Sound.h"

SoundBase* gpSound;
char gacSound[80];

////////////////////////////////////////////////////////////////////////////////

void InitSound(CC64* pC64, HWND /*hwnd*/) {

  pC64->pSID->SetNoSoundMode(false);

  // get user configurable parameters
  //flag fDirectSound = GetInt("Sound", "Use DirectSound (1 or 0)", 1);
  flag fQuickSound = GetInt("Sound", "Use QuickSound (1 or 0)", 1);
  flag fMMSound = GetInt("Sound", "Use MMSound (1 or 0)", 0);
  int iSampleRate = GetInt("Sound", "Sample Rate (11025, 22050, 32000 or 44100 Hz)", 22050);
  int iSampleResolution = GetInt("Sound", "Sample Resolution (8 or 16 bit)", 8);

  // try DirectSound
  /*if (fDirectSound) {
    try {
      trace("Trying DirectSound");
      gpSound = new DirectSound(pC64->pEventRoot, &pC64->SID, 985248, iSampleRate, iSampleResolution, hwnd);
      wsprintf(gacSound, gpSound->GetDescription(), iSampleResolution, iSampleRate);
      trace("Using %s", gacSound);
      return;
    } catch (...) {}
  }*/

  // try QuickSound
  if (fQuickSound) {
    try {
      trace("Trying QuickSound");
      gpSound = new QuickSound(pC64->pSID, 985248, iSampleRate, iSampleResolution);
      wsprintf(gacSound, gpSound->GetDescription(), iSampleResolution, iSampleRate);
      trace("Using %s", gacSound);
      return;
    } catch (...) {}
  }

  // try MMSound
  if (fMMSound) {
    try {
      trace("Trying MMSound");
      gpSound = new MMSound(pC64->pSID, 985248, iSampleRate, iSampleResolution);
      wsprintf(gacSound, gpSound->GetDescription(), iSampleResolution, iSampleRate);
      trace("Using %s", gacSound);
      return;
    } catch (...) {}
  }

  // use NoSound
  gpSound = new NoSound(985248);
  pC64->pSID->SetNoSoundMode(true);
  wsprintf(gacSound, gpSound->GetDescription(), iSampleResolution, iSampleRate);
  trace("Using %s", gacSound);

}

void ExitSound() {
  if (gpSound != NULL) {
    delete gpSound;
    gpSound = NULL;
  }
}

flag Synchronize() {
  return gpSound->Synchronize();
}
