package com.planet_ink.coffee_mud.Abilities.Thief;

import com.planet_ink.coffee_mud.interfaces.*;
import com.planet_ink.coffee_mud.common.*;
import com.planet_ink.coffee_mud.utils.*;
import java.util.*;

/* 
   Copyright 2000-2005 Bo Zimmerman

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
public class Thief_ImprovedHiding extends ThiefSkill
{
	public String ID() { return "Thief_ImprovedHiding"; }
	public String name(){ return "Improved Hiding";}
	public String displayText(){ return "";}
	protected int canAffectCode(){return CAN_MOBS;}
	protected int canTargetCode(){return 0;}
	public int quality(){return Ability.OK_SELF;}
	public boolean isAutoInvoked(){return true;}
	public boolean canBeUninvoked(){return false;}
	public boolean active=false;

	public boolean canBeLearnedBy(MOB teacher, MOB student)
	{
		if(!super.canBeLearnedBy(teacher,student))
			return false;
		if(student==null) return true;
		if(student.fetchAbility("Thief_Hide")==null)
		{
			teacher.tell(student.name()+" has not yet learned to hide.");
			student.tell("You need to learn to hide first.");
			return false;
		}
		return true;
	}

	public void improve(MOB mob, boolean yesorno)
	{
		Ability A=mob.fetchEffect("Thief_Hide");
		if(A!=null)
		{
			if(yesorno)
				A.setAbilityCode(1);
			else
				A.setAbilityCode(0);
		}
	}

	public boolean okMessage(Environmental myHost, CMMsg msg)
	{
		if((affected==null)||(!(affected instanceof MOB)))
			return super.okMessage(myHost,msg);

		MOB mob=(MOB)affected;
		if((!Sense.isHidden(mob))&&(active))
		{
			active=false;
			improve(mob,false);
			mob.recoverEnvStats();
		}
		return super.okMessage(myHost,msg);
	}

	public boolean tick(Tickable ticking, int tickID)
	{
		if(!super.tick(ticking,tickID)) return false;
		if((affected!=null)&&(affected instanceof MOB))
		{
			if(Sense.isHidden(affected))
			{
				if(!active)
				{
					active=true;
					helpProfficiency((MOB)affected);
					improve((MOB)affected,true);
				}
			}
			else
			if(active)
			{
				active=false;
				improve((MOB)affected,false);
			}
		}
		return true;
	}
}
