package com.planet_ink.coffee_mud.Items.Weapons;

import com.planet_ink.coffee_mud.interfaces.*;
import com.planet_ink.coffee_mud.common.*;


/* 
   Copyright 2000-2005 Bo Zimmerman

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
public class Natural extends StdWeapon
{
	public String ID(){	return "Natural";}
	public Natural()
	{
		super();

		setName("fingernails and teeth");
		setDisplayText("A set of claws and teeth are piled here.");
		setDescription("Those hands and claws look fit to kill.");
		baseEnvStats().setAbility(0);
		baseEnvStats().setLevel(0);
		baseEnvStats.setWeight(0);
		baseEnvStats().setAttackAdjustment(0);
		baseEnvStats().setDamage(0);
		weaponType=TYPE_NATURAL;
		recoverEnvStats();
		material=EnvResource.RESOURCE_SCALES;
		weaponClassification=Weapon.CLASS_NATURAL;
	}


	public String hitString(int damageAmount)
	{
		return "<S-NAME> "+CommonStrings.standardHitWord(weaponType,damageAmount)+" <T-NAMESELF>";
	}
}
