package com.planet_ink.coffee_mud.web.macros;
import java.util.*;

import com.planet_ink.coffee_mud.interfaces.*;
import com.planet_ink.coffee_mud.common.*;
import com.planet_ink.coffee_mud.utils.*;


/* 
   Copyright 2000-2005 Bo Zimmerman

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
public class ChannelBackLogNext extends StdWebMacro
{
	public String name()	{return this.getClass().getName().substring(this.getClass().getName().lastIndexOf('.')+1);}

	public String runMacro(ExternalHTTPRequests httpReq, String parm)
	{
		Hashtable parms=parseParms(parm);
		String last=httpReq.getRequestParameter("CHANNELBACKLOG");
		if(parms.containsKey("RESET"))
		{
			if(last!=null) httpReq.removeRequestParameter("CHANNELBACKLOG");
			return "";
		}
		String channel=httpReq.getRequestParameter("CHANNEL");
		if(channel==null) return " @break@";
		int channelInt=ChannelSet.getChannelIndex(channel);
		if(channelInt<0) return " @break@";
		String login=Authenticate.getLogin(httpReq);
		if((Authenticate.authenticated(httpReq,login,Authenticate.getPassword(httpReq))&&(CMMap.getLoadPlayer(login)!=null)))
		{
			MOB mob=CMMap.getLoadPlayer(login);
			if(ChannelSet.mayReadThisChannel(mob,channelInt))
			{
			    Vector que=ChannelSet.getChannelQue(channelInt);
				while(true)
				{
				    int num=Util.s_int(last);
				    last=""+(num+1);
					httpReq.addRequestParameters("CHANNELBACKLOG",last);
					if((num<0)||(num>=que.size()))
					{
						httpReq.addRequestParameters("CHANNELBACKLOG","");
						if(parms.containsKey("EMPTYOK"))
							return "<!--EMPTY-->";
						else
							return " @break@";
					}
					boolean areareq=ChannelSet.getChannelMask(channelInt).toUpperCase().indexOf("SAMEAREA")>=0;
					CMMsg msg=(CMMsg)que.elementAt(num);
					String str=null;
					if((mob==msg.source())&&(msg.sourceMessage()!=null))
					    str=msg.sourceMessage();
					else
					if((mob==msg.target())&&(msg.targetMessage()!=null))
					    str=msg.targetMessage();
					else
					if(msg.othersMessage()!=null)
					    str=msg.othersMessage();
					else
					    str="";
					str=Util.removeColors(str);
					if(ChannelSet.mayReadThisChannel(msg.source(),areareq,mob,channelInt))
						return CoffeeFilter.fullOutFilter(mob.session(),mob,msg.source(),msg.target(),msg.tool(),str,false);
				}
			}
			return "";
		}
		else
			return "";
	}
}
