/*
 * Decompiled with CFR 0.152.
 */
package com.planet_ink.siplet.applet;

import com.jcraft.jzlib.ZStreamException;
import com.planet_ink.siplet.support.TelnetFilter;
import java.applet.Applet;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;

public class Siplet
extends Applet {
    public static final boolean debugDataOut = true;
    public static final long serialVersionUID = 7L;
    public static final float VERSION_MAJOR = 2.0f;
    public static final long VERSION_MINOR = 10L;
    protected StringBuffer buf = new StringBuffer("");
    protected String lastURL = "coffeemud.net";
    protected int lastPort = 23;
    protected Socket sock = null;
    protected InputStream rawin = null;
    protected BufferedReader[] in;
    protected DataOutputStream out;
    protected boolean connected = false;
    protected TelnetFilter Telnet = new TelnetFilter(this);
    protected StringBuffer buffer;
    protected int sillyCounter = 0;

    public void init() {
        this.buffer = new StringBuffer();
    }

    public String info() {
        return "Siplet V2.0.10 (C)2005-2010 Bo Zimmerman";
    }

    public void start() {
        System.out.println("starting siplet 2.0.10 ");
    }

    public void stop() {
        System.out.println("!stopped siplet!");
    }

    public void destroy() {
    }

    public Siplet create() {
        return new Siplet();
    }

    public void addItem(String string) {
        System.out.println(string);
        this.buffer.append(string);
        this.repaint();
    }

    public void paint(Graphics graphics) {
        graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        graphics.drawString(this.buffer.toString(), 5, 15);
    }

    public boolean connectToURL() {
        return this.connectToURL(this.lastURL, this.lastPort);
    }

    public boolean connectToURL(String string, int n) {
        this.connected = false;
        if (this.sock != null) {
            this.disconnectFromURL();
        }
        try {
            this.lastURL = string;
            this.lastPort = n;
            this.sock = new Socket(InetAddress.getByName(string), n);
            Thread.sleep(100L);
            this.rawin = this.sock.getInputStream();
            this.in = new BufferedReader[1];
            this.in[0] = new BufferedReader(new InputStreamReader(this.sock.getInputStream(), "iso-8859-1"));
            this.out = new DataOutputStream(this.sock.getOutputStream());
            this.Telnet = new TelnetFilter(this);
            this.connected = true;
        }
        catch (Exception exception) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(byteArrayOutputStream));
            exception.printStackTrace(printWriter);
            printWriter.flush();
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    public void disconnectFromURL() {
        this.connected = false;
        try {
            if (this.out != null) {
                this.out.write(new byte[]{-1, -3, 18});
                this.out.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.in != null && this.in[0] != null) {
                this.in[0].close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.sock != null) {
                this.sock.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.in = null;
        this.out = null;
        this.sock = null;
    }

    public void sendData(String string) {
        if (this.connected) {
            try {
                if (this.sock.isClosed()) {
                    this.disconnectFromURL();
                } else if (!this.sock.isConnected()) {
                    this.disconnectFromURL();
                } else {
                    this.out.writeBytes(string + "\n\r");
                    this.out.flush();
                }
            }
            catch (IOException iOException) {
                this.disconnectFromURL();
            }
        }
    }

    public String getJScriptCommands() {
        return this.Telnet.getEnquedJScript();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getURLData() {
        StringBuffer stringBuffer = this.buf;
        synchronized (stringBuffer) {
            String string = this.Telnet.getEnquedResponses();
            if (string.length() > 0) {
                this.sendData(string);
            }
            int n = this.Telnet.HTMLFilter(this.buf);
            String string2 = null;
            if (this.buf.length() == 0) {
                return "";
            }
            if (n < 0) {
                n = this.buf.length();
            }
            if (n == 0) {
                return "";
            }
            if (this.Telnet.isUIonHold()) {
                return "";
            }
            if (n < this.buf.length()) {
                string2 = this.buf.substring(0, n);
                this.buf.delete(0, n);
            } else {
                string2 = this.buf.toString();
                this.buf.setLength(0);
            }
            if (string2.length() > 0) {
                System.out.println("/DATA=" + string2);
            }
            return string2;
        }
    }

    public boolean isConnectedToURL() {
        return this.connected;
    }

    public void readURLData() {
        try {
            while (this.connected && this.in[0].ready() && !this.sock.isClosed() && this.sock.isConnected()) {
                try {
                    this.Telnet.TelnetRead(this.buf, this.rawin, this.in);
                }
                catch (InterruptedIOException interruptedIOException) {
                    this.disconnectFromURL();
                    return;
                }
                catch (Exception exception) {
                    if (exception instanceof ZStreamException) {
                        this.disconnectFromURL();
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        this.connectToURL();
                        continue;
                    }
                    this.disconnectFromURL();
                    return;
                }
            }
            if (this.sock.isClosed()) {
                this.disconnectFromURL();
            } else if (!this.sock.isConnected()) {
                this.disconnectFromURL();
            } else if (this.buf.length() > 0) {
                this.Telnet.TelenetFilter(this.buf, this.out, this.rawin, this.in);
            }
        }
        catch (Exception exception) {
            this.disconnectFromURL();
            return;
        }
    }
}

