/*
 * Decompiled with CFR 0.152.
 */
package com.planet_ink.siplet.support;

import com.planet_ink.siplet.support.MXPElement;
import com.planet_ink.siplet.support.MXPEntity;
import com.planet_ink.siplet.support.TelnetFilter;
import com.planet_ink.siplet.support.Util;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class MXP {
    public static final boolean tagDebug = false;
    public static final boolean tagDebugLong = false;
    public static final boolean entityDebug = false;
    private int defaultMode = 0;
    public static final int MODE_LINE_OPEN = 0;
    public static final int MODE_LINE_SECURE = 1;
    public static final int MODE_LINE_LOCKED = 2;
    public static final int MODE_RESET = 3;
    public static final int MODE_TEMP_SECURE = 4;
    public static final int MODE_LOCK_OPEN = 5;
    public static final int MODE_LOCK_SECURE = 6;
    public static final int MODE_LOCK_LOCKED = 7;
    public static final int MODE_LINE_ROOMNAME = 10;
    public static final int MODE_LINE_ROOMDESC = 11;
    public static final int MODE_LINE_ROOMEXITS = 12;
    public static final int MODE_LINE_WELCOME = 19;
    private Hashtable elements = new Hashtable();
    private Hashtable tags = new Hashtable();
    private Hashtable entities = new Hashtable();
    private Vector openElements = new Vector();
    public String lastForeground = "WH";
    public String lastBackground = "WH";
    private boolean eatTextUntilEOLN = false;
    private boolean eatNextEOLN = false;
    private boolean eatAllEOLN = false;
    private StringBuffer responses = new StringBuffer("");
    private StringBuffer jscriptBuffer = new StringBuffer("");
    private Vector gauges = new Vector();
    private int mode = 0;

    public MXP() {
        this.initMXP();
    }

    public void initMXP() {
        this.elements.clear();
        this.addElement(new MXPElement("B", "<B>", "", "", 16));
        this.addElement(new MXPElement("BOLD", "<B>", "", "", 16));
        this.addElement(new MXPElement("STRONG", "<B>", "", "", 16));
        this.addElement(new MXPElement("U", "<U>", "", "", 16));
        this.addElement(new MXPElement("UNDERLINE", "<U>", "", "", 16));
        this.addElement(new MXPElement("I", "<I>", "", "", 16));
        this.addElement(new MXPElement("ITALIC", "<I>", "", "", 16));
        this.addElement(new MXPElement("S", "<S>", "", "", 16));
        this.addElement(new MXPElement("STRIKEOUT", "<S>", "", "", 16));
        this.addElement(new MXPElement("EM", "<I>", "", "", 16));
        this.addElement(new MXPElement("H1", "<H1>", "", "", 16));
        this.addElement(new MXPElement("H2", "<H2>", "", "", 16));
        this.addElement(new MXPElement("H3", "<H3>", "", "", 16));
        this.addElement(new MXPElement("H4", "<H4>", "", "", 16));
        this.addElement(new MXPElement("H5", "<H5>", "", "", 16));
        this.addElement(new MXPElement("H6", "<H6>", "", "", 16));
        this.addElement(new MXPElement("HR", "<HR>", "", "", 18));
        this.addElement(new MXPElement("SMALL", "<SMALL>", "", "", 16));
        this.addElement(new MXPElement("TT", "<PRE>", "", "", 16));
        this.addElement(new MXPElement("BR", "<BR>", "", "", 18));
        this.addElement(new MXPElement("SBR", "&nbsp;", "", "", 50));
        this.addElement(new MXPElement("P", "", "", "", 24));
        this.addElement(new MXPElement("C", "<FONT COLOR=&fore; BACK=&back;>", "FORE BACK", "", 0));
        this.addElement(new MXPElement("COLOR", "<FONT COLOR=&fore; BACK=&back;>", "FORE BACK", "", 0));
        this.addElement(new MXPElement("HIGH", "", "", "", 32));
        this.addElement(new MXPElement("H", "", "", "", 32));
        this.addElement(new MXPElement("FONT", "<FONT STYLE=\"color: &color;;background-color: &back;;font-family: &face;;font-size: &size;;\">", "FACE SIZE COLOR BACK STYLE", "", 8));
        this.addElement(new MXPElement("NOBR", "", "", "", 10));
        this.addElement(new MXPElement("A", "<A STYLE=\"&lcc;\" ONMOUSEOVER=\"&onmouseover;\" ONCLICK=\"&onclick;\" HREF=\"&href;\" TITLE=\"&hint;\">", "HREF HINT EXPIRE TITLE=HINT STYLE ONMOUSEOUT ONMOUSEOVER ONCLICK", "", 0, "EXPIRE"));
        this.addElement(new MXPElement("SEND", "<A STYLE=\"&lcc;\" HREF=\"&href;\" ONMOUSEOUT=\"delayhidemenu();\" ONCLICK=\"&onclick;\" TITLE=\"&hint;\">", "HREF HINT PROMPT EXPIRE STYLE", "", 8, "EXPIRE"));
        this.addElement(new MXPElement("EXPIRE", "", "NAME", "", 32));
        this.addElement(new MXPElement("VERSION", "", "", "", 10));
        this.addElement(new MXPElement("SUPPORT", "", "", "", 10));
        this.addElement(new MXPElement("GAUGE", "", "ENTITY MAX CAPTION COLOR", "", 10));
        this.addElement(new MXPElement("STAT", "", "ENTITY MAX CAPTION", "", 42));
        this.addElement(new MXPElement("FRAME", "", "NAME ACTION TITLE INTERNAL ALIGN LEFT TOP WIDTH HEIGHT SCROLLING FLOATING", "", 42));
        this.addElement(new MXPElement("DEST", "", "NAME", "", 40));
        this.addElement(new MXPElement("DESTINATION", "", "NAME", "", 40));
        this.addElement(new MXPElement("RELOCATE", "", "URL PORT", "", 42));
        this.addElement(new MXPElement("USER", "", "", "", 34));
        this.addElement(new MXPElement("PASSWORD", "", "", "", 34));
        this.addElement(new MXPElement("IMAGE", "<IMG SRC=&url;&fname; HEIGHT=&h; WIDTH=&w; ALIGN=&align;>", "FNAME URL T H W HSPACE VSPACE ALIGN ISMAP", "", 2, "HSPACE VSPACE ISMAP"));
        this.addElement(new MXPElement("IMG", "<IMG SRC=&src; HEIGHT=&height; WIDTH=&width; ALIGN=&align;>", "SRC HEIGHT=70 WIDTH=70 ALIGN", "", 2));
        this.addElement(new MXPElement("FILTER", "", "SRC DEST NAME", "", 34));
        this.addElement(new MXPElement("SCRIPT", "", "", "", 34));
        this.addElement(new MXPElement("ENTITY", "", "NAME VALUE DESC PRIVATE PUBLISH DELETE ADD", "", 10, "PRIVATE PUBLISH ADD"));
        this.addElement(new MXPElement("EN", "", "NAME VALUE DESC PRIVATE PUBLISH DELETE ADD", "", 10, "PRIVATE PUBLISH ADD"));
        this.addElement(new MXPElement("TAG", "", "INDEX WINDOWNAME FORE BACK GAG ENABLE DISABLE", "", 10, "WINDOWNAME"));
        this.addElement(new MXPElement("VAR", "", "NAME DESC PRIVATE PUBLISH DELETE ADD REMOVE", "", 8, "PRIVATE PUBLISH ADD REMOVE"));
        this.addElement(new MXPElement("V", "", "NAME DESC PRIVATE PUBLISH DELETE ADD REMOVE", "", 8, "PRIVATE PUBLISH ADD REMOVE"));
        this.addElement(new MXPElement("ELEMENT", "", "NAME DEFINITION ATT TAG FLAG OPEN DELETE EMPTY", "", 10));
        this.addElement(new MXPElement("EL", "", "NAME DEFINITION ATT TAG FLAG OPEN DELETE EMPTY", "", 10));
        this.addElement(new MXPElement("ATTLIST", "", "NAME ATT", "", 10));
        this.addElement(new MXPElement("AT", "", "NAME ATT", "", 10));
        this.addElement(new MXPElement("SOUND", "!!SOUND(&fname; V=&v; L=&l; P=&p; T=&t; U=&u;)", "FNAME V=100 L=1 P=50 T U", "", 2));
        this.addElement(new MXPElement("MUSIC", "!!MUSIC(&fname; V=&v; L=&l; P=&p; T=&t; U=&u;)", "FNAME V=100 L=1 P=50 T U", "", 2));
        this.entities.clear();
        this.entities.put("nbsp", new MXPEntity("nbsp", "&nbsp;"));
        this.entities.put("lt", new MXPEntity("lt", "&lt;"));
        this.entities.put("gt", new MXPEntity("gt", "&gt;"));
        this.entities.put("quot", new MXPEntity("quot", "&quot;"));
        this.entities.put("amp", new MXPEntity("amp", "&amp;"));
    }

    public void addElement(MXPElement mXPElement) {
        this.elements.put(mXPElement.name(), mXPElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAnyResponses() {
        StringBuffer stringBuffer = this.responses;
        synchronized (stringBuffer) {
            if (this.responses.length() == 0) {
                return "";
            }
            String string = this.responses.toString();
            this.responses.setLength(0);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAnyJScript() {
        StringBuffer stringBuffer = this.jscriptBuffer;
        synchronized (stringBuffer) {
            if (this.jscriptBuffer.length() == 0) {
                return "";
            }
            String string = this.jscriptBuffer.toString();
            this.jscriptBuffer.setLength(0);
            return string;
        }
    }

    private int mode() {
        return this.mode;
    }

    private void setMode(int n) {
        this.mode = n;
    }

    private int setModeAndExecute(int n, StringBuffer stringBuffer, int n2) {
        this.setMode(n);
        return this.executeMode(stringBuffer, n2);
    }

    private int executeMode(StringBuffer stringBuffer, int n) {
        switch (this.mode()) {
            case 3: {
                this.mode = this.defaultMode = 0;
                return this.closeAllTags(stringBuffer, n);
            }
            case 5: 
            case 6: 
            case 7: {
                this.defaultMode = this.mode;
            }
        }
        return 0;
    }

    public int newlineDetected(StringBuffer stringBuffer, int n, boolean[] blArray) {
        if (this.mode() == 2 || this.mode() == 7) {
            blArray[0] = false;
            return 0;
        }
        blArray[0] = this.eatNextEOLN;
        this.eatNextEOLN = this.eatAllEOLN;
        if (this.eatTextUntilEOLN) {
            this.eatTextUntilEOLN = false;
            blArray[0] = true;
        }
        switch (this.mode()) {
            case 0: {
                int n2 = this.closeAllTags(stringBuffer, n);
                this.setModeAndExecute(this.defaultMode, stringBuffer, n);
                return n2;
            }
            case 1: 
            case 2: 
            case 4: {
                int n3 = this.closeAllTags(stringBuffer, n);
                this.setModeAndExecute(this.defaultMode, stringBuffer, n);
                return n3;
            }
        }
        return 0;
    }

    private int closeAllTags(StringBuffer stringBuffer, int n) {
        MXPElement mXPElement = null;
        for (int i = this.openElements.size() - 1; i >= 0; --i) {
            mXPElement = (MXPElement)this.openElements.elementAt(i);
            if (!mXPElement.isOpen()) continue;
            String string = this.closeTag(mXPElement);
            if (string.length() > 0) {
                stringBuffer.insert(n, string + ">");
            }
            this.openElements.removeElementAt(i);
        }
        return 0;
    }

    public boolean isUIonHold() {
        if (this.mode() == 2 || this.mode() == 7) {
            return false;
        }
        MXPElement mXPElement = null;
        for (int i = 0; i < this.openElements.size(); ++i) {
            mXPElement = (MXPElement)this.openElements.elementAt(i);
            if (!mXPElement.needsText()) continue;
            return true;
        }
        return false;
    }

    private String closeTag(MXPElement mXPElement) {
        Vector vector = mXPElement.getCloseTags(mXPElement.getDefinition());
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = vector.size() - 1; i >= 0; --i) {
            if (!this.elements.containsKey(((String)vector.elementAt(i)).toUpperCase().trim())) continue;
            stringBuffer.append("</" + ((String)vector.elementAt(i)).toUpperCase().trim());
        }
        return stringBuffer.toString();
    }

    public int escapeTranslate(String string, StringBuffer stringBuffer, int n) {
        if (string.endsWith("z")) {
            MXPElement mXPElement;
            stringBuffer.delete(n, n + string.length() + 2);
            int n2 = Util.s0_int(string.substring(0, string.length() - 1));
            if (n2 < 20) {
                return this.setModeAndExecute(n2, stringBuffer, n);
            }
            if (n2 < 100 && (mXPElement = (MXPElement)this.tags.get(n2)) != null && !mXPElement.isDisabled()) {
                stringBuffer.insert(n, mXPElement.getFoldedDefinition(""));
                if (mXPElement.isTextEater()) {
                    this.eatTextUntilEOLN = true;
                }
            }
            return -1;
        }
        return string.length();
    }

    public boolean eatTextUntilNextEOLN() {
        return this.eatTextUntilEOLN;
    }

    private void processAnyEntities(StringBuffer stringBuffer, MXPElement mXPElement) {
        block3: for (int i = 0; i < stringBuffer.length(); ++i) {
            switch (stringBuffer.charAt(i)) {
                case '&': {
                    int n = this.processEntity(stringBuffer, i, mXPElement, false);
                    if (n == Integer.MAX_VALUE) {
                        return;
                    }
                    i += n;
                    continue block3;
                }
            }
        }
    }

    private String substr(String string, int n, int n2) {
        return this.substr(new StringBuffer(string), n, n2);
    }

    private String substr(StringBuffer stringBuffer, int n, int n2) {
        if (n < 0) {
            return "?";
        }
        if (n2 < n) {
            n2 = n + 80;
        }
        if (n2 > stringBuffer.length()) {
            n2 = stringBuffer.length();
        }
        String string = stringBuffer.substring(n, n2);
        string = Util.replaceAll(string, "\n", "\\n");
        string = Util.replaceAll(string, "\r", "\\r");
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int processTag(StringBuffer stringBuffer, int n) {
        Object object;
        boolean bl;
        if (this.mode() == 2 || this.mode() == 7) {
            stringBuffer.setCharAt(n, '&');
            stringBuffer.insert(n + 1, "lt;");
            return 3;
        }
        Vector<String> vector = new Vector<String>();
        int n2 = n;
        int n3 = n;
        int n4 = 32;
        char c = '\u0000';
        StringBuffer stringBuffer2 = new StringBuffer("");
        if (n + 1 < stringBuffer.length() && (stringBuffer.charAt(n + 1) == '!' || stringBuffer.charAt(n + 1) == '/')) {
            stringBuffer2.append(stringBuffer.charAt(++n));
        }
        while (stringBuffer2 != null && ++n < stringBuffer.length()) {
            switch (stringBuffer.charAt(n)) {
                case '\n': 
                case '\r': {
                    stringBuffer.setCharAt(n2, '&');
                    stringBuffer.insert(n2 + 1, "lt;");
                    return 3;
                }
                case '\t': 
                case ' ': {
                    if (c == '\u0000') {
                        if (stringBuffer2.length() > 0) {
                            vector.addElement(stringBuffer2.toString());
                        }
                        stringBuffer2.setLength(0);
                        break;
                    }
                    stringBuffer2.append(stringBuffer.charAt(n));
                    break;
                }
                case '\"': 
                case '\'': {
                    if (n4 == 92) {
                        if (c == '\u0000' && stringBuffer2.length() <= 0) {
                            stringBuffer.setCharAt(n2, '&');
                            stringBuffer.insert(n2 + 1, "lt;");
                            return 3;
                        }
                        stringBuffer2.append(stringBuffer.charAt(n));
                        break;
                    }
                    if (n4 == 61 || c != '\u0000' || c == '\u0000' && (n4 == 32 || n4 == 9)) {
                        if (c != '\u0000' && c == stringBuffer.charAt(n)) {
                            c = '\u0000';
                            vector.addElement(stringBuffer2.toString());
                            stringBuffer2.setLength(0);
                            break;
                        }
                        if (c != '\u0000') {
                            stringBuffer2.append(stringBuffer.charAt(n));
                            break;
                        }
                        c = stringBuffer.charAt(n);
                        break;
                    }
                    stringBuffer2.append(stringBuffer.charAt(n));
                    break;
                }
                case '<': {
                    if (c == '\u0000') {
                        stringBuffer.setCharAt(n2, '&');
                        stringBuffer.insert(n2 + 1, "lt;");
                        return 3;
                    }
                    stringBuffer2.append(stringBuffer.charAt(n));
                    break;
                }
                case '>': {
                    if (c != '\u0000') {
                        stringBuffer2.append(stringBuffer.charAt(n));
                        break;
                    }
                    if (stringBuffer2.length() > 0) {
                        vector.add(stringBuffer2.toString());
                    }
                    stringBuffer2 = null;
                    break;
                }
                default: {
                    if (c == '\u0000' && !Character.isLetter(stringBuffer.charAt(n)) && stringBuffer2.length() <= 0) {
                        stringBuffer.setCharAt(n2, '&');
                        stringBuffer.insert(n2 + 1, "lt;");
                        return 3;
                    }
                    stringBuffer2.append(stringBuffer.charAt(n));
                    break;
                }
            }
            n4 = stringBuffer.charAt(n);
        }
        if (n >= stringBuffer.length() || stringBuffer.charAt(n) != '>') {
            return Integer.MAX_VALUE;
        }
        int n5 = n + 1;
        String string = vector.size() > 0 ? ((String)vector.firstElement()).toUpperCase().trim() : "";
        String string2 = stringBuffer.substring(n2, n5);
        if (string.startsWith("!")) {
            string = string.substring(1);
        }
        if (bl = string.startsWith("/")) {
            string = string.substring(1);
        }
        if ((string = string.toUpperCase().trim()).length() == 0 || !this.elements.containsKey(string)) {
            stringBuffer.setCharAt(n2, '&');
            stringBuffer.insert(n2 + 1, "lt;");
            return 3;
        }
        MXPElement mXPElement = (MXPElement)this.elements.get(string);
        String string3 = "";
        if (!bl) {
            mXPElement = mXPElement.copyOf();
            vector.removeElementAt(0);
            mXPElement.saveSettings(n2, vector);
            if (!mXPElement.isCommand()) {
                this.openElements.addElement(mXPElement);
            }
            stringBuffer.delete(n2, n5);
            if (mXPElement.needsText()) {
                return -1;
            }
        } else {
            String string4;
            object = null;
            int n6 = -1;
            for (int i = this.openElements.size() - 1; i >= 0; --i) {
                mXPElement = (MXPElement)this.openElements.elementAt(i);
                if (mXPElement.name().equals(string)) {
                    n6 = i;
                    this.openElements.removeElementAt(i);
                    break;
                }
                if (!mXPElement.needsText()) continue;
                object = mXPElement;
            }
            stringBuffer.delete(n2, n5);
            if (n6 < 0) {
                return -1;
            }
            if (object != null) {
                this.openElements.removeElement(object);
            }
            if ((string4 = this.closeTag(mXPElement)).length() > 0) {
                stringBuffer.insert(n2, string4 + ">");
            }
            if (mXPElement.needsText()) {
                string3 = stringBuffer.substring(mXPElement.getBufInsert(), n2);
                string3 = Util.stripBadHTMLTags(Util.replaceAll(string3, "&nbsp;", " "));
                n2 = mXPElement.getBufInsert();
            } else {
                if (mXPElement.isHTML()) {
                    if (mXPElement.isSpecialProcessor()) {
                        this.specialProcessorElements(mXPElement, true);
                    }
                    return string4.length();
                }
                if (string4.equals("</" + mXPElement.name())) {
                    return string4.length();
                }
                if (mXPElement.getBufInsert() < n2) {
                    return -(n2 - mXPElement.getBufInsert() + 1);
                }
                return string4.length();
            }
        }
        object = mXPElement.getFoldedDefinition(string3);
        if (bl && !mXPElement.isCommand() && mXPElement.getFlag() != null && mXPElement.getFlag().length() > 0) {
            String string5 = mXPElement.getFlag().trim();
            if (string5.toUpperCase().startsWith("SET ")) {
                string5 = string5.substring(4).trim();
            }
            this.modifyEntity(string5, string3);
        }
        if (mXPElement.isSpecialProcessor()) {
            this.specialProcessorElements(mXPElement, bl);
        }
        if (mXPElement.isHTML() || ((String)object).equalsIgnoreCase(string2)) {
            stringBuffer.insert(n2, (String)object);
            if (bl && n2 < n3) {
                return -(n3 - n2 + 1);
            }
            return ((String)object).length() - 1;
        }
        StringBuffer stringBuffer3 = new StringBuffer((String)object);
        this.processAnyEntities(stringBuffer3, mXPElement);
        stringBuffer.insert(n2, stringBuffer3.toString());
        if (bl && n2 < n3) {
            return -(n3 - n2 + 1);
        }
        if (!stringBuffer3.toString().equalsIgnoreCase(string2) && !mXPElement.name().toUpperCase().trim().equals(this.getFirstTag(stringBuffer3.toString().trim()))) {
            return -1;
        }
        return stringBuffer3.toString().length() - 1;
    }

    public String getFirstTag(String string) {
        if (!string.startsWith("<")) {
            return "";
        }
        int n = string.indexOf(32);
        if (n < 0) {
            n = string.indexOf(62);
        }
        if (n < 0) {
            return "";
        }
        return string.substring(1, n).toUpperCase().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void specialProcessorElements(MXPElement mXPElement, boolean bl) {
        if (mXPElement.name().equals("FONT")) {
            String string = mXPElement.getAttributeValue("STYLE");
            String string2 = mXPElement.getAttributeValue("COLOR");
            String string3 = mXPElement.getAttributeValue("BACK");
            String string4 = mXPElement.getAttributeValue("FACE");
            String string5 = mXPElement.getAttributeValue("SIZE");
            if (string != null && string2 == null && string3 == null && string4 == null && string5 == null) {
                String string6 = null;
                String string7 = null;
                while (string.length() > 0) {
                    int n;
                    int n2 = string.indexOf(59);
                    if (n2 >= 0) {
                        string6 = string.substring(0, n2).trim();
                        string = string.substring(n2 + 1).trim();
                    } else {
                        string6 = string.trim();
                        string = "";
                    }
                    if ((n = string6.indexOf(58)) < 0) continue;
                    string7 = string6.substring(n + 1);
                    if ((string6 = string6.substring(0, n)).equalsIgnoreCase("color")) {
                        mXPElement.setAttributeValue("COLOR", string7);
                        continue;
                    }
                    if (string6.equalsIgnoreCase("background-color")) {
                        mXPElement.setAttributeValue("BACK", string7);
                        continue;
                    }
                    if (string6.equalsIgnoreCase("font-size")) {
                        mXPElement.setAttributeValue("SIZE", string7);
                        continue;
                    }
                    if (!string6.equalsIgnoreCase("font-family")) continue;
                    mXPElement.setAttributeValue("FACE", string7);
                }
                mXPElement.setAttributeValue("STYLE", null);
            }
        } else if (mXPElement.name().equals("NOBR")) {
            this.eatNextEOLN = true;
        } else if (mXPElement.name().equals("P")) {
            if (bl) {
                this.eatAllEOLN = false;
                this.eatNextEOLN = false;
            } else {
                this.eatAllEOLN = true;
                this.eatNextEOLN = true;
            }
        } else if (mXPElement.name().equals("SEND")) {
            String string = mXPElement.getAttributeValue("PROMPT");
            if (string != null && string.length() > 0) {
                return;
            }
            string = string == null ? "false" : "true";
            mXPElement.setAttributeValue("PROMPT", string);
            String string8 = mXPElement.getAttributeValue("HREF");
            String string9 = mXPElement.getAttributeValue("HINT");
            if (string8 == null || string8.trim().length() == 0) {
                string8 = "alert('Nothing done.');";
            }
            if (string9 == null || string9.trim().length() == 0) {
                string9 = "Click here!";
            }
            string9 = Util.replaceAllIgnoreCase(string9, "RIGHT-CLICK", "click");
            string9 = Util.replaceAllIgnoreCase(string9, "RIGHT-MOUSE", "click mouse");
            mXPElement.setAttributeValue("ONCLICK", "");
            mXPElement.setAttributeValue("HREF", "");
            mXPElement.setAttributeValue("HINT", "");
            Vector vector = Util.parsePipes(string8, true);
            Vector vector2 = Util.parsePipes(string9, true);
            if (vector.size() == 1) {
                string8 = Util.replaceAll((String)vector.firstElement(), "'", "\\'");
                mXPElement.setAttributeValue("HREF", "javascript:addToPrompt('" + string8 + "'," + string + ")");
                if (vector2.size() > 1) {
                    string9 = (String)vector2.firstElement();
                }
                mXPElement.setAttributeValue("HINT", string9);
            } else if (vector2.size() > vector.size()) {
                mXPElement.setAttributeValue("HINT", (String)vector2.firstElement());
                vector2.removeElementAt(0);
                mXPElement.setAttributeValue("HREF", "javascript:goDefault(0);");
                StringBuffer stringBuffer = new StringBuffer("");
                for (int i = 0; i < vector2.size(); ++i) {
                    stringBuffer.append((String)vector2.elementAt(i));
                    if (i >= vector2.size() - 1) continue;
                    stringBuffer.append("|");
                }
                string8 = Util.replaceAll(string8, "'", "\\'");
                string9 = Util.replaceAll(stringBuffer.toString(), "'", "\\'");
                mXPElement.setAttributeValue("ONCLICK", "return dropdownmenu(this, event, getSendMenu(this,'" + string8 + "','" + string9 + "','" + string + "'), '200px');");
            } else {
                mXPElement.setAttributeValue("HINT", "Click to open menu");
                mXPElement.setAttributeValue("HREF", "javascript:goDefault(0);");
                string8 = Util.replaceAll(string8, "'", "\\'");
                string9 = Util.replaceAll(string9, "'", "\\'");
                mXPElement.setAttributeValue("ONCLICK", "return dropdownmenu(this, event, getSendMenu(this,'" + string8 + "','" + string9 + "','" + string + "'), '200px');");
            }
        } else {
            if (mXPElement.name().equals("ELEMENT") || mXPElement.name().equals("EL")) {
                String string = mXPElement.getAttributeValue("NAME");
                String string10 = mXPElement.getAttributeValue("DEFINITION");
                String string11 = mXPElement.getAttributeValue("ATT");
                String string12 = mXPElement.getAttributeValue("TAG");
                String string13 = mXPElement.getAttributeValue("FLAG");
                String string14 = mXPElement.getAttributeValue("OPEN");
                String string15 = mXPElement.getAttributeValue("DELETE");
                String string16 = mXPElement.getAttributeValue("EMPTY");
                if (string == null) {
                    return;
                }
                if (string15 != null && this.elements.containsKey(string)) {
                    mXPElement = (MXPElement)this.elements.get(string);
                    if (mXPElement.isOpen()) {
                        this.elements.remove(string);
                    }
                    return;
                }
                if (string10 == null) {
                    string10 = "";
                }
                if (string11 == null) {
                    string11 = "";
                }
                int n = 0;
                if (string14 != null) {
                    n |= 1;
                }
                if (string16 != null) {
                    n |= 2;
                }
                MXPElement mXPElement2 = new MXPElement(string.toUpperCase().trim(), string10, string11, string13, n);
                mXPElement2.setNotBasicElement();
                this.elements.remove(mXPElement2.name());
                this.elements.put(mXPElement2.name(), mXPElement2);
                if (string12 != null && Util.isInteger(string12) && Util.s_int(string12) > 19 && Util.s_int(string12) < 100) {
                    int n3 = Util.s_int(string12);
                    if (this.tags.containsKey(n3)) {
                        this.tags.remove(n3);
                    }
                    this.tags.put(n3, mXPElement2);
                }
                return;
            }
            if (mXPElement.name().equals("ENTITY") || mXPElement.name().equals("EN")) {
                String string = mXPElement.getAttributeValue("NAME");
                String string17 = mXPElement.getAttributeValue("VALUE");
                String string18 = mXPElement.getAttributeValue("DELETE");
                String string19 = mXPElement.getAttributeValue("REMOVE");
                String string20 = mXPElement.getAttributeValue("ADD");
                if (string == null || string.length() == 0) {
                    return;
                }
                if (string18 != null) {
                    this.entities.remove(string);
                    return;
                }
                if (string19 == null && string20 == null) {
                    this.modifyEntity(string, string17);
                }
                return;
            }
            if ((mXPElement.name().equals("VAR") || mXPElement.name().equals("V")) && bl) {
                String string = mXPElement.getAttributeValue("NAME");
                String string21 = mXPElement.getAttributeValue("DELETE");
                String string22 = mXPElement.getAttributeValue("REMOVE");
                String string23 = mXPElement.getAttributeValue("TEXT");
                if (string23 == null) {
                    string23 = "";
                }
                String string24 = mXPElement.getAttributeValue("ADD");
                if (string == null || string.length() == 0) {
                    return;
                }
                if (string21 != null) {
                    this.entities.remove(string);
                    return;
                }
                if (string22 == null && string24 == null) {
                    this.modifyEntity(string, string23);
                }
                return;
            }
            if (mXPElement.name().equalsIgnoreCase("VERSION")) {
                this.responses.append("\u001b[1z<VERSION MXP=1.0 STYLE=1.0 CLIENT=Siplet VERSION=" + TelnetFilter.getSipletVersion() + " REGISTERED=NO>\n");
            } else {
                if (mXPElement.name().equalsIgnoreCase("GAUGE")) {
                    String string;
                    String string25 = mXPElement.getAttributeValue("ENTITY");
                    String string26 = mXPElement.getAttributeValue("MAX");
                    if (string25 == null || string26 == null) {
                        return;
                    }
                    string25 = string25.toLowerCase();
                    string26 = string26.toLowerCase();
                    String string27 = mXPElement.getAttributeValue("CAPTION");
                    if (string27 == null) {
                        string27 = "";
                    }
                    if ((string = mXPElement.getAttributeValue("COLOR")) == null) {
                        string = "WHITE";
                    }
                    String string28 = this.getEntityValue(string25, null);
                    int n = 0;
                    if (string28 != null && Util.isInteger(string28)) {
                        n = Util.s_int(string28);
                    }
                    String string29 = this.getEntityValue(string26, null);
                    int n4 = 100;
                    if (string29 != null && Util.isInteger(string29)) {
                        n4 = Util.s_int(string29);
                    }
                    if (n4 < n) {
                        int n5 = n4 = n <= 0 ? 100 : n;
                    }
                    if (n > 0) {
                        n = (int)Math.round(Util.mul(100.0, n / n4));
                    }
                    StringBuffer stringBuffer = this.jscriptBuffer;
                    synchronized (stringBuffer) {
                        this.jscriptBuffer.append("createGauge('" + string25 + "','" + string27 + "','" + string + "'," + n + "," + n4 + ");");
                        String[] stringArray = new String[]{string25, string26};
                        this.gauges.addElement(stringArray);
                    }
                }
                if (mXPElement.name().equalsIgnoreCase("ATTLIST") || mXPElement.name().equalsIgnoreCase("ATT")) {
                    String string = mXPElement.getAttributeValue("NAME");
                    String string30 = mXPElement.getAttributeValue("ATT");
                    if (string == null || string30 == null) {
                        return;
                    }
                    MXPElement mXPElement3 = (MXPElement)this.elements.get(string.toUpperCase().trim());
                    if (mXPElement3 == null) {
                        return;
                    }
                    mXPElement3.setAttributes(string30);
                } else if (mXPElement.name().equalsIgnoreCase("SUPPORT")) {
                    StringBuffer stringBuffer = new StringBuffer("");
                    List<String> list = mXPElement.getUserParms();
                    if (list == null || list.size() == 0) {
                        Enumeration enumeration = this.elements.elements();
                        while (enumeration.hasMoreElements()) {
                            MXPElement mXPElement4 = (MXPElement)enumeration.nextElement();
                            if (!mXPElement4.isBasicElement()) continue;
                            Vector vector = mXPElement4.getUnsupportedParms();
                            if (!mXPElement4.isGenerallySupported()) {
                                stringBuffer.append(" -" + mXPElement4.name());
                                continue;
                            }
                            stringBuffer.append(" +" + mXPElement4.name());
                            if (vector.size() <= 0) continue;
                            for (int i = 0; i < vector.size(); ++i) {
                                stringBuffer.append(" -" + mXPElement4.name() + "." + (String)vector.elementAt(i));
                            }
                        }
                    } else {
                        for (int i = 0; i < list.size(); ++i) {
                            MXPElement mXPElement5;
                            String string = list.get(i).trim().toUpperCase();
                            if (string.startsWith("\"")) {
                                string = string.substring(1).trim();
                            }
                            if (string.endsWith("\"")) {
                                string = string.substring(0, string.length() - 1).trim();
                            }
                            if (string.startsWith("'")) {
                                string = string.substring(1).trim();
                            }
                            if (string.endsWith("'")) {
                                string = string.substring(0, string.length() - 1).trim();
                            }
                            int n = string.indexOf(46);
                            String string31 = string;
                            String string32 = "";
                            if (n > 0) {
                                string31 = string.substring(0, n).trim();
                                string32 = string.substring(n + 1).trim();
                            }
                            if ((mXPElement5 = (MXPElement)this.elements.get(string31)) == null || !mXPElement5.isGenerallySupported()) {
                                if (string32.length() > 0 && !string32.equals("*")) {
                                    stringBuffer.append(" -" + string31 + "." + string32);
                                    continue;
                                }
                                stringBuffer.append(" -" + string31);
                                continue;
                            }
                            if (string32.length() == 0) {
                                stringBuffer.append(" +" + string31);
                                continue;
                            }
                            Vector vector = mXPElement5.getUnsupportedParms();
                            Vector vector3 = mXPElement5.getParsedAttributes();
                            if (string32.equals("*")) {
                                for (int j = 0; j < vector3.size(); ++j) {
                                    String string33 = (String)vector3.elementAt(j);
                                    if (vector.contains(string33)) continue;
                                    stringBuffer.append(" +" + string31 + "." + string33);
                                }
                                continue;
                            }
                            if (vector.contains(string32) || !vector3.contains(string32)) {
                                stringBuffer.append(" -" + string31 + "." + string32);
                                continue;
                            }
                            stringBuffer.append(" +" + string31 + "." + string32);
                        }
                    }
                    this.responses.append("\u001b[1z<SUPPORTS" + stringBuffer.toString() + ">\n");
                } else if (mXPElement.name().equals("TAG")) {
                    MXPElement mXPElement6;
                    String string;
                    this.addElement(new MXPElement("TAG", "", "INDEX WINDOWNAME FORE BACK GAG ENABLE DISABLE", "", 10));
                    String string34 = mXPElement.getAttributeValue("INDEX");
                    if (!Util.isNumber(string34)) {
                        return;
                    }
                    int n = Util.s_int(string34);
                    if (n < 20 || n > 99) {
                        return;
                    }
                    String string35 = mXPElement.getAttributeValue("FORE");
                    if (string35 == null) {
                        string35 = "";
                    }
                    if ((string = mXPElement.getAttributeValue("BACK")) == null) {
                        string = "";
                    }
                    String string36 = mXPElement.getAttributeValue("GAG");
                    String string37 = mXPElement.getAttributeValue("ENABLE");
                    String string38 = mXPElement.getAttributeValue("DISABLE");
                    StringBuffer stringBuffer = new StringBuffer("");
                    if (string35.length() > 0 || string.length() > 0) {
                        stringBuffer.append("<FONT ");
                        if (string35.length() > 0) {
                            stringBuffer.append(" COLOR=" + string35);
                        }
                        if (string.length() > 0) {
                            stringBuffer.append(" BACK=" + string);
                        }
                        stringBuffer.append(">");
                    }
                    if ((mXPElement6 = (MXPElement)this.tags.get(n)) == null) {
                        return;
                    }
                    int n6 = mXPElement6.getBitmap();
                    if (string36 != null) {
                        n6 |= 0x40;
                    } else if (string38 != null) {
                        n6 |= 0x80;
                    } else if (mXPElement6.isDisabled() && string37 != null) {
                        n6 -= 128;
                    }
                    mXPElement6.setBitmap(n6);
                    if (stringBuffer.length() > 0) {
                        String string39 = Util.stripBadHTMLTags(mXPElement6.getDefinition());
                        mXPElement6.setDefinition(string39 + stringBuffer.toString());
                    }
                    return;
                }
            }
        }
    }

    public String getEntityValue(String string, MXPElement mXPElement) {
        String string2 = null;
        if (string.equalsIgnoreCase("lcc")) {
            string2 = "color: " + this.lastForeground + "; background-color: " + this.lastBackground;
        }
        if (string2 == null) {
            String string3 = string2 = mXPElement != null ? mXPElement.getAttributeValue(string) : null;
        }
        if (string2 == null && mXPElement != null) {
            string2 = mXPElement.getAttributeValue(string.toLowerCase());
        }
        if (string2 == null && mXPElement != null) {
            string2 = mXPElement.getAttributeValue(string.toUpperCase());
        }
        if (string2 == null && mXPElement == null) {
            MXPElement mXPElement2;
            int n;
            for (n = this.openElements.size() - 1; n >= 0 && (string2 = (mXPElement2 = (MXPElement)this.openElements.elementAt(n)).getAttributeValue(string)) == null; --n) {
            }
            if (string2 == null) {
                for (n = this.openElements.size() - 1; n >= 0 && (string2 = (mXPElement2 = (MXPElement)this.openElements.elementAt(n)).getAttributeValue(string.toLowerCase())) == null; --n) {
                }
            }
            if (string2 == null) {
                for (n = this.openElements.size() - 1; n >= 0 && (string2 = (mXPElement2 = (MXPElement)this.openElements.elementAt(n)).getAttributeValue(string.toUpperCase())) == null; --n) {
                }
            }
        }
        if (string2 == null) {
            MXPEntity mXPEntity = (MXPEntity)this.entities.get(string);
            if (mXPEntity == null) {
                mXPEntity = (MXPEntity)this.entities.get(string.toLowerCase());
            }
            if (mXPEntity == null) {
                mXPEntity = (MXPEntity)this.entities.get(string.toUpperCase());
            }
            if (mXPEntity != null) {
                string2 = mXPEntity.getDefinition();
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyEntity(String string, String string2) {
        MXPEntity mXPEntity = (MXPEntity)this.entities.get(string = string.toLowerCase());
        if (mXPEntity == null) {
            mXPEntity = new MXPEntity(string, string2);
            this.entities.put(string, mXPEntity);
        } else {
            if (mXPEntity.getDefinition().equalsIgnoreCase(string2)) {
                return;
            }
            mXPEntity.setDefinition(string2);
        }
        String[] stringArray = null;
        for (int i = 0; i < this.gauges.size(); ++i) {
            stringArray = (String[])this.gauges.elementAt(i);
            if (!stringArray[0].equalsIgnoreCase(string) && !stringArray[1].equalsIgnoreCase(string)) continue;
            String string3 = this.getEntityValue(stringArray[0], null);
            int n = 0;
            if (string3 != null && Util.isInteger(string3)) {
                n = Util.s_int(string3);
            }
            String string4 = this.getEntityValue(stringArray[1], null);
            int n2 = 100;
            if (string4 != null && Util.isInteger(string4)) {
                n2 = Util.s_int(string4);
            }
            if (n2 < n) {
                int n3 = n2 = n <= 0 ? 100 : n;
            }
            if (n > 0) {
                n = (int)Math.round(Util.mul(100.0, Util.div(n, n2)));
            }
            StringBuffer stringBuffer = this.jscriptBuffer;
            synchronized (stringBuffer) {
                this.jscriptBuffer.append("modifyGauge('" + stringArray[0] + "'," + n + "," + n2 + ");");
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownMXP() {
        this.openElements.clear();
        this.eatAllEOLN = false;
        this.eatNextEOLN = false;
        this.eatTextUntilEOLN = false;
        this.initMXP();
        this.jscriptBuffer.setLength(0);
        this.responses.setLength(0);
        while (this.gauges.size() > 0) {
            StringBuffer stringBuffer = this.jscriptBuffer;
            synchronized (stringBuffer) {
                this.jscriptBuffer.append("removeGauge('" + ((String[])this.gauges.elementAt(0))[0] + "');");
            }
            this.gauges.removeElementAt(0);
        }
        this.mode = 0;
        this.defaultMode = 0;
        this.tags.clear();
    }

    public int processEntity(StringBuffer stringBuffer, int n, MXPElement mXPElement, boolean bl) {
        if (this.mode() == 2 || this.mode() == 7) {
            return 0;
        }
        boolean bl2 = false;
        int n2 = n;
        StringBuffer stringBuffer2 = new StringBuffer("");
        if (stringBuffer.charAt(n + 1) == '#' && Character.isDigit(stringBuffer.charAt(n + 2))) {
            ++n;
            while (++n < stringBuffer.length()) {
                if (stringBuffer.charAt(n) == ';') {
                    bl2 = false;
                } else {
                    if (Character.isDigit(stringBuffer.charAt(n))) continue;
                    bl2 = true;
                }
                break;
            }
        } else {
            while (++n < stringBuffer.length()) {
                if (stringBuffer.charAt(n) == ';') {
                    bl2 = false;
                    break;
                }
                if (!Character.isLetterOrDigit(stringBuffer.charAt(n))) {
                    bl2 = true;
                    break;
                }
                if (!Character.isLetter(stringBuffer.charAt(n)) && stringBuffer2.length() == 0) {
                    bl2 = true;
                    break;
                }
                stringBuffer2.append(stringBuffer.charAt(n));
                if (stringBuffer2.length() <= 20) continue;
            }
        }
        if (n >= stringBuffer.length() && stringBuffer2.length() > 0 && stringBuffer.length() - n < 10) {
            return Integer.MAX_VALUE;
        }
        if (bl2 || stringBuffer2.length() == 0 || stringBuffer.charAt(n) != ';') {
            if (bl) {
                stringBuffer.insert(n2 + 1, "amp;");
                return 4;
            }
            return 0;
        }
        String string = stringBuffer2.toString().trim();
        String string2 = this.getEntityValue(string, mXPElement);
        String string3 = stringBuffer.substring(n2, n + 1);
        stringBuffer.delete(n2, n + 1);
        if (string2 != null) {
            if (mXPElement != null && mXPElement.name().equalsIgnoreCase("FONT")) {
                if (string.equalsIgnoreCase("COLOR")) {
                    this.lastForeground = string2;
                } else if (string.equalsIgnoreCase("BACK")) {
                    this.lastBackground = string2;
                }
            }
            stringBuffer.insert(n2, string2);
            if (string2.equalsIgnoreCase(string3) || mXPElement != null) {
                return string2.length() - 1;
            }
            return -1;
        }
        return -1;
    }
}

