/*
 * Decompiled with CFR 0.152.
 */
package com.planet_ink.siplet.support;

import com.planet_ink.siplet.support.Util;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MXPElement
implements Cloneable {
    public static final int BIT_OPEN = 1;
    public static final int BIT_COMMAND = 2;
    public static final int BIT_NEEDTEXT = 4;
    public static final int BIT_SPECIAL = 8;
    public static final int BIT_HTML = 16;
    public static final int BIT_NOTSUPPORTED = 32;
    public static final int BIT_EATTEXT = 64;
    public static final int BIT_DISABLED = 128;
    private String name = "";
    private String definition = "";
    private String attributes = "";
    private String flag = "";
    private String unsupportedParms = "";
    private int bitmap = 0;
    private Vector parsedAttributes = null;
    private Hashtable attributeValues = null;
    private Hashtable alternativeAttributes = null;
    private List<String> userParms = new Vector<String>();
    private boolean basicElement = true;
    private int bufInsert = -1;

    public MXPElement(String string, String string2, String string3, String string4, int n) {
        this.name = string;
        this.definition = string2;
        this.attributes = string3;
        this.flag = string4;
        this.bitmap = n;
        if (!this.isCommand() && string2.toUpperCase().indexOf("&TEXT;") >= 0) {
            this.bitmap |= 4;
        }
    }

    public MXPElement(String string, String string2, String string3, String string4, int n, String string5) {
        this.name = string;
        this.definition = string2;
        this.attributes = string3;
        this.flag = string4;
        this.bitmap = n;
        if (!this.isCommand() && string2.toUpperCase().indexOf("&TEXT;") >= 0) {
            this.bitmap |= 4;
        }
        this.unsupportedParms = string5;
    }

    public MXPElement copyOf() {
        try {
            MXPElement mXPElement = (MXPElement)this.clone();
            if (mXPElement.parsedAttributes != null) {
                mXPElement.parsedAttributes = (Vector)mXPElement.parsedAttributes.clone();
            }
            if (mXPElement.attributeValues != null) {
                mXPElement.attributeValues = (Hashtable)mXPElement.attributeValues.clone();
            }
            if (mXPElement.alternativeAttributes != null) {
                mXPElement.alternativeAttributes = (Hashtable)mXPElement.alternativeAttributes.clone();
            }
            if (mXPElement.userParms != null) {
                mXPElement.userParms = new Vector<String>(mXPElement.userParms);
            }
            return mXPElement;
        }
        catch (Exception exception) {
            return this;
        }
    }

    public String name() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isCommand() {
        return Util.bset(this.bitmap, 2);
    }

    public boolean isOpen() {
        return Util.bset(this.bitmap, 1);
    }

    public boolean isHTML() {
        return Util.bset(this.bitmap, 16);
    }

    public boolean isSpecialProcessor() {
        return Util.bset(this.bitmap, 8);
    }

    public boolean isDisabled() {
        return Util.bset(this.bitmap, 128);
    }

    public boolean isTextEater() {
        return Util.bset(this.bitmap, 64);
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String string) {
        this.definition = string;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public boolean needsText() {
        return Util.bset(this.bitmap, 4);
    }

    public void setNotBasicElement() {
        this.basicElement = false;
    }

    public boolean isBasicElement() {
        return this.basicElement;
    }

    public boolean isGenerallySupported() {
        return !Util.bset(this.bitmap, 32);
    }

    public void setBitmap(int n) {
        this.bitmap = n;
    }

    public int getBitmap() {
        return this.bitmap;
    }

    public Vector getUnsupportedParms() {
        if (this.unsupportedParms == null || this.unsupportedParms.trim().length() == 0) {
            return new Vector();
        }
        return Util.parseSpaces(this.unsupportedParms, true);
    }

    public void setAttributes(String string) {
        this.attributes = string;
        this.parsedAttributes = null;
        this.attributeValues = null;
        this.alternativeAttributes = null;
    }

    public String getAttributeValue(String string) {
        this.getParsedAttributes();
        return (String)this.attributeValues.get(string.toUpperCase().trim());
    }

    public void setAttributeValue(String string, String string2) {
        this.getParsedAttributes();
        this.attributeValues.remove(string);
        if (string2 != null) {
            this.attributeValues.put(string, string2);
        }
    }

    public synchronized Vector getParsedAttributes() {
        if (this.parsedAttributes != null) {
            return this.parsedAttributes;
        }
        this.parsedAttributes = new Vector();
        this.attributeValues = new Hashtable();
        this.alternativeAttributes = new Hashtable();
        StringBuffer stringBuffer = new StringBuffer(this.attributes.trim());
        StringBuffer stringBuffer2 = new StringBuffer("");
        char c = '\u0000';
        int n = -1;
        int n2 = 32;
        boolean bl = false;
        while (++n < stringBuffer.length()) {
            switch (stringBuffer.charAt(n)) {
                case '=': {
                    if (!bl && stringBuffer2.length() > 0) {
                        String string = stringBuffer2.toString().toUpperCase().trim();
                        stringBuffer2 = new StringBuffer("");
                        this.parsedAttributes.addElement(string);
                        this.attributeValues.put(string, stringBuffer2);
                    } else {
                        stringBuffer2.append(stringBuffer.charAt(n));
                    }
                    bl = true;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (c == '\u0000') {
                        if (!bl && stringBuffer2.length() > 0) {
                            this.parsedAttributes.addElement(stringBuffer2.toString().toUpperCase().trim());
                        }
                        stringBuffer2 = new StringBuffer("");
                        bl = false;
                        break;
                    }
                    stringBuffer2.append(stringBuffer.charAt(n));
                    break;
                }
                case '\"': 
                case '\'': {
                    if (n2 == 92) {
                        stringBuffer2.append(stringBuffer.charAt(n));
                        break;
                    }
                    if (n2 == 61 || c != '\u0000' || c == '\u0000' && (n2 == 32 || n2 == 9)) {
                        if (c != '\u0000' && c == stringBuffer.charAt(n)) {
                            c = '\u0000';
                            if (!bl && stringBuffer2.length() > 0) {
                                this.parsedAttributes.addElement(stringBuffer2.toString().toUpperCase().trim());
                            }
                            stringBuffer2 = new StringBuffer("");
                            bl = false;
                            break;
                        }
                        if (c != '\u0000') {
                            stringBuffer2.append(stringBuffer.charAt(n));
                            break;
                        }
                        c = stringBuffer.charAt(n);
                        break;
                    }
                    stringBuffer2.append(stringBuffer.charAt(n));
                    break;
                }
                default: {
                    stringBuffer2.append(stringBuffer.charAt(n));
                }
            }
            n2 = stringBuffer.charAt(n);
        }
        if (!bl && stringBuffer2.length() > 0) {
            this.parsedAttributes.addElement(stringBuffer2.toString().toUpperCase().trim());
        }
        for (int i = this.parsedAttributes.size() - 1; i >= 0; --i) {
            String string = (String)this.parsedAttributes.elementAt(i);
            StringBuffer stringBuffer3 = (StringBuffer)this.attributeValues.get(string);
            if (stringBuffer3 == null || !this.parsedAttributes.contains(stringBuffer3.toString())) continue;
            this.parsedAttributes.removeElementAt(i);
            this.attributeValues.remove(string);
            this.alternativeAttributes.put(string, stringBuffer3.toString());
        }
        return this.parsedAttributes;
    }

    public String getFlag() {
        return this.flag;
    }

    public List<String> getUserParms() {
        return this.userParms;
    }

    public void saveSettings(int n, Vector vector) {
        this.bufInsert = n;
        this.userParms = vector;
    }

    public int getBufInsert() {
        return this.bufInsert;
    }

    public void deleteAttribute(String string) {
        this.getParsedAttributes();
        this.attributeValues.remove(string.toUpperCase().trim());
    }

    public Vector getCloseTags(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer2 = null;
        char c = '\u0000';
        int n = -1;
        int n2 = 32;
        while (++n < stringBuffer.length()) {
            switch (stringBuffer.charAt(n)) {
                case '<': {
                    if (c != '\u0000') {
                        stringBuffer2 = null;
                        break;
                    }
                    if (stringBuffer2 != null) {
                        return vector;
                    }
                    stringBuffer2 = new StringBuffer("");
                    break;
                }
                case '>': {
                    if (c == '\u0000' && stringBuffer2 != null && stringBuffer2.toString().trim().length() > 0) {
                        vector.add(stringBuffer2.toString().toUpperCase().trim());
                    }
                    stringBuffer2 = null;
                    break;
                }
                case '\t': 
                case ' ': {
                    if (c == '\u0000' && stringBuffer2 != null && stringBuffer2.toString().trim().length() > 0) {
                        vector.add(stringBuffer2.toString().toUpperCase().trim());
                    }
                    stringBuffer2 = null;
                    break;
                }
                case '\"': 
                case '\'': {
                    if (n2 == 92) {
                        stringBuffer2 = null;
                    } else if (c != '\u0000' && c == stringBuffer.charAt(n)) {
                        c = '\u0000';
                    } else if (c == '\u0000') {
                        c = stringBuffer.charAt(n);
                    }
                    stringBuffer2 = null;
                    break;
                }
                default: {
                    if (stringBuffer2 != null && Character.isLetterOrDigit(stringBuffer.charAt(n))) {
                        stringBuffer2.append(stringBuffer.charAt(n));
                        break;
                    }
                    stringBuffer2 = null;
                }
            }
            n2 = stringBuffer.charAt(n);
        }
        return vector;
    }

    public String getFoldedDefinition(String string) {
        Vector vector = this.getParsedAttributes();
        this.attributeValues.remove("TEXT");
        this.attributeValues.put("TEXT", string);
        if (this.userParms != null && this.userParms.size() > 0) {
            int n = -1;
            String string2 = null;
            String string3 = null;
            for (int i = 0; i < this.userParms.size(); ++i) {
                string3 = this.userParms.get(i).toUpperCase().trim();
                int n2 = string3.indexOf(61);
                if (n2 > 0 && this.alternativeAttributes.containsKey(string3.substring(0, n2).trim())) {
                    String string4 = (String)this.alternativeAttributes.get(string3.substring(0, n2).trim());
                    String string5 = this.userParms.get(i);
                    n2 = string5.indexOf(61);
                    this.userParms.set(i, string4 + string5.substring(n2));
                    string3 = this.userParms.get(i).toUpperCase().trim();
                }
                boolean bl = false;
                for (int j = 0; j < vector.size(); ++j) {
                    string2 = (String)vector.elementAt(j);
                    if (!string3.startsWith(string2 + "=") && !string2.equals(string3)) continue;
                    bl = true;
                    if (j > n) {
                        n = j;
                    }
                    this.attributeValues.remove(string2);
                    String string6 = string2.equals(string3) ? "" : this.userParms.get(i).trim().substring(string2.length() + 1);
                    this.attributeValues.put(string2, string6);
                    break;
                }
                if (bl || n >= vector.size() - 1) continue;
                string2 = (String)vector.elementAt(++n);
                this.attributeValues.remove(string2);
                this.attributeValues.put(string2, this.userParms.get(i).trim());
            }
        }
        return this.definition;
    }
}

