/*
 * Decompiled with CFR 0.152.
 */
package com.planet_ink.siplet.support;

import com.jcraft.jzlib.ZInputStream;
import com.planet_ink.siplet.applet.Siplet;
import com.planet_ink.siplet.support.MSP;
import com.planet_ink.siplet.support.MXP;
import com.planet_ink.siplet.support.Util;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.util.Vector;

public class TelnetFilter {
    public static final boolean debugChars = false;
    public static final boolean debugTelnetCodes = false;
    protected static final char IAC_SE = '\u00f0';
    protected static final char IAC_ = '\u00ff';
    protected static final char IAC_SB = '\u00fa';
    protected static final char IAC_DO = '\u00fd';
    protected static final char IAC_WILL = '\u00fb';
    protected static final char IAC_WONT = '\u00fc';
    protected static final char IAC_DONT = '\u00fe';
    protected static final char IAC_MSP = 'Z';
    protected static final char IAC_MXP = '[';
    protected static final char TELOPT_BINARY = '\u0000';
    protected static final char TELOPT_EOR = '\u0019';
    protected static final char TELOPT_ECHO = '\u0001';
    protected static final char TELOPT_NAWS = '\u001f';
    protected static final char TELOPT_LOGOUT = '\u0012';
    protected static final char TELOPT_TTYPE = '\u0018';
    protected static final char TELOPT_TSPEED = ' ';
    protected static final char MCCP_COMPRESS = 'U';
    protected static final char MCCP_COMPRESS2 = 'V';
    protected static final char TELOPT_NEWENVIRONMENT = '\'';
    private static String defaultBackground = "black";
    private static String defaultForeground = "white";
    private static String[] colorCodes1 = new String[]{"black", "#993300", "green", "#999966", "#000099", "purple", "darkcyan", "lightgrey"};
    private static String[] colorCodes2 = new String[]{"gray", "red", "lightgreen", "yellow", "blue", "violet", "cyan", "white"};
    protected String lastBackground = null;
    protected String lastForeground = null;
    protected boolean blinkOn = false;
    protected boolean fontOn = false;
    protected boolean boldOn = false;
    protected boolean underlineOn = false;
    protected boolean italicsOn = false;
    private Siplet codeBase = null;
    protected boolean comment = false;
    protected boolean neverSupportMSP = false;
    protected boolean neverSupportMXP = false;
    protected boolean neverSupportMCCP = false;
    protected boolean MSPsupport = false;
    protected boolean MXPsupport = false;
    protected boolean MCCPsupport = false;
    private MSP mspModule = new MSP();
    private MXP mxpModule = new MXP();
    public static final char[] mccppattern = new char[]{'\u00ff', '\u00fa', 'V', '\u00ff', '\u00f0'};
    public int patDex = 0;

    private TelnetFilter() {
    }

    public TelnetFilter(Siplet siplet) {
        this();
        this.codeBase = siplet;
    }

    public static String getSipletVersion() {
        return "2.0.10";
    }

    public String getEnquedResponses() {
        return this.MXPsupport() ? this.mxpModule.getAnyResponses() : "";
    }

    public String getEnquedJScript() {
        return this.mxpModule != null ? this.mxpModule.getAnyJScript() : "";
    }

    public boolean MSPsupport() {
        return this.MSPsupport;
    }

    public void setMSPSupport(boolean bl) {
        this.MSPsupport = bl;
    }

    public boolean MXPsupport() {
        return this.MXPsupport;
    }

    public void setMXPSupport(boolean bl) {
        this.MXPsupport = bl;
    }

    public boolean MCCPsupport() {
        return this.MCCPsupport;
    }

    public void setMCCPSupport(boolean bl) {
        this.MCCPsupport = bl;
    }

    public boolean isUIonHold() {
        return this.MXPsupport() && this.mxpModule.isUIonHold();
    }

    private String blinkOff() {
        if (this.blinkOn) {
            this.blinkOn = false;
            return "</BLINK>";
        }
        return "";
    }

    private String underlineOff() {
        if (this.underlineOn) {
            this.underlineOn = false;
            return "</U>";
        }
        return "";
    }

    private String fontOff() {
        if (this.fontOn) {
            this.setLastBackground(defaultBackground);
            this.setLastForeground(defaultForeground);
            this.fontOn = false;
            return "</FONT>";
        }
        return "";
    }

    private String italicsOff() {
        if (this.italicsOn) {
            this.italicsOn = false;
            return "</I>";
        }
        return "";
    }

    private String allOff() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(this.blinkOff());
        stringBuffer.append(this.underlineOff());
        stringBuffer.append(this.fontOff());
        stringBuffer.append(this.italicsOff());
        return stringBuffer.toString();
    }

    public static int getColorCodeIndex(String string) {
        int n;
        if (string == null) {
            string = defaultForeground;
        }
        for (n = 0; n < colorCodes1.length; ++n) {
            if (!string.equalsIgnoreCase(colorCodes1[n])) continue;
            return 40 + n;
        }
        for (n = 0; n < colorCodes2.length; ++n) {
            if (!string.equalsIgnoreCase(colorCodes2[n])) continue;
            return 30 + n;
        }
        return 30;
    }

    public static int getRelativeColorCodeIndex(String string) {
        int n = TelnetFilter.getColorCodeIndex(string);
        if (n < 40) {
            return n - 30;
        }
        if (n > 50) {
            return n % 10;
        }
        return n - 40;
    }

    private void setLastBackground(String string) {
        if (this.MXPsupport()) {
            this.mxpModule.lastBackground = string;
        } else {
            this.lastBackground = string;
        }
    }

    private void setLastForeground(String string) {
        if (this.MXPsupport()) {
            this.mxpModule.lastForeground = string;
        } else {
            this.lastForeground = string;
        }
    }

    private String lastBackground() {
        return this.MXPsupport() ? this.mxpModule.lastBackground : this.lastBackground;
    }

    private String lastForeground() {
        return this.MXPsupport() ? this.mxpModule.lastForeground : this.lastForeground;
    }

    private String escapeTranslate(String string) {
        if (string.endsWith("m")) {
            Vector vector = Util.parseSemicolons(string.substring(0, string.length() - 1), true);
            StringBuffer stringBuffer = new StringBuffer("");
            String string2 = null;
            int n = 0;
            String string3 = null;
            String string4 = null;
            for (int i = 0; i < vector.size(); ++i) {
                string2 = (String)vector.elementAt(i);
                n = Util.s0_int(string2);
                switch (n) {
                    case 0: {
                        if (i == vector.size() - 1) {
                            stringBuffer.append(this.allOff());
                        }
                        this.boldOn = false;
                        break;
                    }
                    case 1: {
                        this.boldOn = true;
                        if (vector.size() != 1 || this.lastForeground() == null) break;
                        string4 = colorCodes2[TelnetFilter.getRelativeColorCodeIndex(this.lastForeground())];
                        break;
                    }
                    case 4: {
                        if (this.underlineOn) break;
                        this.underlineOn = true;
                        stringBuffer.append("<U>");
                        break;
                    }
                    case 5: {
                        if (this.blinkOn) break;
                        this.blinkOn = true;
                        stringBuffer.append("<BLINK>");
                        break;
                    }
                    case 6: {
                        if (this.italicsOn) break;
                        this.italicsOn = true;
                        stringBuffer.append("<I>");
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 8: {
                        string3 = defaultBackground;
                        string4 = defaultBackground;
                        break;
                    }
                    case 22: {
                        stringBuffer.append(this.allOff());
                        break;
                    }
                    case 24: {
                        stringBuffer.append(this.underlineOff());
                        break;
                    }
                    case 25: {
                        stringBuffer.append(this.blinkOff());
                        break;
                    }
                    case 26: {
                        stringBuffer.append(this.italicsOff());
                        break;
                    }
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: {
                        string4 = this.boldOn ? colorCodes2[n - 30] : colorCodes1[n - 30];
                        break;
                    }
                    case 39: {
                        string4 = defaultForeground;
                        break;
                    }
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: {
                        string3 = colorCodes1[n - 40];
                        break;
                    }
                    case 49: {
                        string3 = defaultForeground;
                    }
                }
                if (string3 == null && string4 == null) continue;
                if (this.lastBackground() == null) {
                    this.setLastBackground(defaultBackground);
                }
                if (this.lastForeground() == null) {
                    this.setLastForeground(defaultForeground);
                }
                if (string3 == null) {
                    string3 = this.lastBackground();
                }
                if (string4 == null) {
                    string4 = this.lastForeground();
                }
                if (this.lastBackground().equals(string3) && this.lastForeground().equals(string4)) continue;
                stringBuffer.append(this.fontOff());
                this.setLastBackground(string3);
                this.setLastForeground(string4);
                this.fontOn = true;
                if (this.MXPsupport()) {
                    stringBuffer.append("<FONT COLOR=" + string4 + " BACK=" + string3 + ">");
                    continue;
                }
                stringBuffer.append("<FONT STYLE=\"color: " + string4 + ";background-color: " + string3 + "\">");
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public void TelnetRead(StringBuffer stringBuffer, InputStream inputStream, BufferedReader[] bufferedReaderArray) throws InterruptedIOException, IOException {
        char c = (char)bufferedReaderArray[0].read();
        if (mccppattern[this.patDex] == c) {
            ++this.patDex;
            if (this.patDex >= mccppattern.length && !this.neverSupportMCCP) {
                while (inputStream.available() > 0) {
                    inputStream.read();
                }
                ZInputStream zInputStream = new ZInputStream(inputStream);
                bufferedReaderArray[0] = new BufferedReader(new InputStreamReader((InputStream)zInputStream));
                this.patDex = 0;
            }
            return;
        }
        if (this.patDex > 0) {
            for (int i = 0; i < this.patDex; ++i) {
                stringBuffer.append(mccppattern[i]);
            }
            this.patDex = 0;
        }
        stringBuffer.append(c);
        if (c == '\uffff') {
            throw new InterruptedIOException("ARGH!");
        }
    }

    public int TelenetFilter(StringBuffer stringBuffer, DataOutputStream dataOutputStream, InputStream inputStream, BufferedReader[] bufferedReaderArray) throws IOException {
        block10: for (int i = 0; i < stringBuffer.length(); ++i) {
            switch (stringBuffer.charAt(i)) {
                case '\u00ff': {
                    if (i >= stringBuffer.length() - 2) {
                        return i;
                    }
                    int n = i++;
                    int n2 = n + 3;
                    switch (stringBuffer.charAt(i)) {
                        case '\u00fa': {
                            byte[] byArray;
                            Object[] objectArray = new char[1024];
                            char c = stringBuffer.charAt(++i);
                            int n3 = 0;
                            char c2 = '\u0000';
                            while (i < stringBuffer.length() - 1 && (c2 = stringBuffer.charAt(++i)) != '\uffffffff' && n3 < objectArray.length) {
                                if (c2 == '\u00ff' && i < stringBuffer.length() - 1) {
                                    if ((c2 = stringBuffer.charAt(++i)) == '\u00ff') {
                                        objectArray[n3++] = 255;
                                        continue;
                                    }
                                    if (c2 != '\u00f0') continue;
                                    break;
                                }
                                objectArray[n3++] = c2;
                            }
                            n2 = i + 1;
                            if (c == '\u0018') {
                                byArray = new byte[]{115, 105, 112, 108, 101, 116};
                                dataOutputStream.writeBytes("\u00ff\u00fa\u0018\u0000");
                                dataOutputStream.write(byArray);
                                dataOutputStream.writeBytes("\u00ff\u00f0");
                                dataOutputStream.flush();
                                break;
                            }
                            if (c == '\u001f') {
                                byArray = new byte[4];
                                byArray[1] = 80;
                                byArray[3] = 25;
                                dataOutputStream.writeBytes("\u00ff\u00fa\u001f");
                                dataOutputStream.write(byArray);
                                dataOutputStream.writeBytes("\u00ff\u00f0");
                                dataOutputStream.flush();
                                break;
                            }
                            if (c != 'V') break;
                            break;
                        }
                        case '\u00fb': {
                            Object[] objectArray;
                            if (stringBuffer.charAt(++i) == '\u001f') {
                                objectArray = new byte[4];
                                objectArray[1] = 80;
                                objectArray[3] = 25;
                                dataOutputStream.writeBytes("\u00ff\u00fa\u001f");
                                dataOutputStream.write((byte[])objectArray);
                                dataOutputStream.writeBytes("\u00ff\u00f0");
                                break;
                            }
                            if (stringBuffer.charAt(i) == 'Z') {
                                if (this.neverSupportMSP) {
                                    if (!this.MSPsupport()) break;
                                    dataOutputStream.writeBytes("\u00ff\u00feZ");
                                    dataOutputStream.flush();
                                    this.setMSPSupport(false);
                                    break;
                                }
                                if (this.MSPsupport()) break;
                                dataOutputStream.writeBytes("\u00ff\u00fdZ");
                                dataOutputStream.flush();
                                this.setMSPSupport(true);
                                break;
                            }
                            if (stringBuffer.charAt(i) == '[') {
                                if (this.neverSupportMXP) {
                                    if (!this.MXPsupport()) break;
                                    dataOutputStream.writeBytes("\u00ff\u00fe[");
                                    dataOutputStream.flush();
                                    this.setMXPSupport(false);
                                    break;
                                }
                                if (this.MXPsupport()) break;
                                dataOutputStream.writeBytes("\u00ff\u00fd[");
                                dataOutputStream.flush();
                                this.setMXPSupport(true);
                                break;
                            }
                            if (stringBuffer.charAt(i) == 'V') {
                                if (this.neverSupportMCCP) {
                                    if (!this.MCCPsupport()) break;
                                    dataOutputStream.writeBytes("\u00ff\u00feV");
                                    dataOutputStream.flush();
                                    this.setMXPSupport(false);
                                    break;
                                }
                                if (this.MCCPsupport()) break;
                                dataOutputStream.writeBytes("\u00ff\u00fdV");
                                dataOutputStream.flush();
                                this.setMCCPSupport(true);
                                break;
                            }
                            if (stringBuffer.charAt(i) == '\u0012' || stringBuffer.charAt(i) == '\u0000') break;
                            dataOutputStream.writeBytes("\u00ff\u00fe" + stringBuffer.charAt(i));
                            dataOutputStream.flush();
                            break;
                        }
                        case '\u00fc': {
                            if (stringBuffer.charAt(++i) == 'Z') {
                                if (!this.MSPsupport()) break;
                                dataOutputStream.writeBytes("\u00ff\u00feZ");
                                dataOutputStream.flush();
                                this.setMSPSupport(false);
                                break;
                            }
                            if (stringBuffer.charAt(i) != '[' || !this.MXPsupport()) break;
                            dataOutputStream.writeBytes("\u00ff\u00fe[");
                            dataOutputStream.flush();
                            this.setMXPSupport(false);
                            if (this.mxpModule == null) break;
                            this.mxpModule.shutdownMXP();
                            break;
                        }
                        case '\u00fd': {
                            if (stringBuffer.charAt(++i) == 'Z') {
                                if (this.neverSupportMSP) {
                                    if (!this.MSPsupport()) break;
                                    dataOutputStream.writeBytes("\u00ff\u00fcZ");
                                    dataOutputStream.flush();
                                    this.setMSPSupport(false);
                                    break;
                                }
                                if (this.MSPsupport()) break;
                                dataOutputStream.writeBytes("\u00ff\u00fbZ");
                                dataOutputStream.flush();
                                this.setMSPSupport(true);
                                break;
                            }
                            if (stringBuffer.charAt(i) == '\u0012') break;
                            if (stringBuffer.charAt(i) == '[') {
                                if (this.neverSupportMXP) {
                                    if (!this.MXPsupport()) break;
                                    dataOutputStream.writeBytes("\u00ff\u00fc[");
                                    dataOutputStream.flush();
                                    this.setMXPSupport(false);
                                    break;
                                }
                                if (this.MXPsupport()) break;
                                dataOutputStream.writeBytes("\u00ff\u00fb[");
                                dataOutputStream.flush();
                                this.setMXPSupport(true);
                                break;
                            }
                            if (stringBuffer.charAt(i) == '\u0000') break;
                            dataOutputStream.writeBytes("\u00ff\u00fc" + stringBuffer.charAt(i));
                            dataOutputStream.flush();
                            break;
                        }
                        case '\u00fe': {
                            if (stringBuffer.charAt(++i) == 'Z') {
                                if (!this.MSPsupport()) break;
                                dataOutputStream.writeBytes("\u00ff\u00fcZ");
                                dataOutputStream.flush();
                                this.setMSPSupport(false);
                                break;
                            }
                            if (stringBuffer.charAt(i) != '[' || !this.MXPsupport()) break;
                            dataOutputStream.writeBytes("\u00ff\u00fc[");
                            dataOutputStream.flush();
                            this.setMXPSupport(false);
                            if (this.mxpModule == null) break;
                            this.mxpModule.shutdownMXP();
                        }
                    }
                    stringBuffer.delete(n, n2);
                    i = n - 1;
                    continue block10;
                }
            }
        }
        return stringBuffer.length();
    }

    public int HTMLFilter(StringBuffer stringBuffer) {
        boolean[] blArray = new boolean[1];
        block11: for (int i = 0; i < stringBuffer.length(); ++i) {
            if (this.comment) {
                if (!stringBuffer.substring(i, i + 3).equals("-->")) continue;
                this.comment = false;
                i += 3;
                continue;
            }
            if (this.MXPsupport() && this.mxpModule.eatTextUntilNextEOLN() && stringBuffer.charAt(i) != '\n' && stringBuffer.charAt(i) != '\r') {
                stringBuffer.deleteCharAt(i);
                --i;
                continue;
            }
            switch (stringBuffer.charAt(i)) {
                case '!': {
                    if (i >= stringBuffer.length() - 3 || stringBuffer.charAt(i + 1) != '!' || !this.MSPsupport()) continue block11;
                    int n = this.mspModule.process(stringBuffer, i, this.codeBase);
                    if (n == -1) {
                        --i;
                        continue block11;
                    }
                    if (n <= 0) continue block11;
                    return n;
                }
                case '&': {
                    if (!this.MXPsupport()) {
                        stringBuffer.insert(i + 1, "amp;");
                        i += 4;
                        continue block11;
                    }
                    int n = this.mxpModule.processEntity(stringBuffer, i, null, true);
                    if (n == Integer.MAX_VALUE) {
                        return i;
                    }
                    i += n;
                    continue block11;
                }
                case ' ': {
                    stringBuffer.setCharAt(i, '&');
                    stringBuffer.insert(i + 1, "nbsp;");
                    i += 5;
                    continue block11;
                }
                case '>': {
                    stringBuffer.setCharAt(i, '&');
                    stringBuffer.insert(i + 1, "gt;");
                    i += 3;
                    continue block11;
                }
                case '<': {
                    if (!this.MXPsupport()) {
                        stringBuffer.setCharAt(i, '&');
                        stringBuffer.insert(i + 1, "lt;");
                        i += 3;
                        continue block11;
                    }
                    if (i + 4 < stringBuffer.length() && stringBuffer.substring(i + 1, i + 4).equals("!--")) {
                        this.comment = true;
                        continue block11;
                    }
                    int n = this.mxpModule.processTag(stringBuffer, i);
                    if (n == Integer.MAX_VALUE) {
                        return i;
                    }
                    i += n;
                    continue block11;
                }
                case '\n': {
                    int n;
                    if (this.MXPsupport()) {
                        n = this.mxpModule.newlineDetected(stringBuffer, i + 1, blArray);
                        if (blArray[0]) {
                            stringBuffer.deleteCharAt(i);
                        } else {
                            stringBuffer.setCharAt(i, '<');
                            stringBuffer.insert(i + 1, "BR>");
                            i += 3;
                        }
                        i += n;
                        continue block11;
                    }
                    stringBuffer.setCharAt(i, '<');
                    stringBuffer.insert(i + 1, "BR>");
                    i += 3;
                    continue block11;
                }
                case '\r': {
                    stringBuffer.deleteCharAt(i);
                    --i;
                    continue block11;
                }
                case '\u00ff': {
                    if (i < stringBuffer.length() - 3) continue block11;
                    return i;
                }
                case '\u001b': {
                    int n = i;
                    if (i == stringBuffer.length() - 1) {
                        return i;
                    }
                    if (stringBuffer.charAt(++i) != '[') {
                        stringBuffer.setCharAt(i, ' ');
                        continue block11;
                    }
                    boolean bl = false;
                    while (++i < stringBuffer.length() && (bl || !Character.isLetter(stringBuffer.charAt(i)))) {
                        if (stringBuffer.charAt(i) != '\"') continue;
                        bl = !bl;
                    }
                    if (i == stringBuffer.length()) {
                        return n;
                    }
                    String string = stringBuffer.substring(n + 2, i + 1);
                    String string2 = this.escapeTranslate(string);
                    if (string2.equals(string)) {
                        int n2 = this.mxpModule.escapeTranslate(string, stringBuffer, n);
                        if (n2 == Integer.MAX_VALUE) {
                            return i;
                        }
                        i = n + n2;
                        continue block11;
                    }
                    if (string2.equals(string)) continue block11;
                    stringBuffer.replace(n, i + 1, string2);
                    i = n + string2.length() - 1;
                }
            }
        }
        return stringBuffer.length();
    }
}

