/*
 * Decompiled with CFR 0.152.
 */
package com.planet_ink.siplet.support;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class Util {
    public static final String SPACES = "                                                                     ";

    public static String toSemicolonList(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(Byte.toString(byArray[i]) + (i < byArray.length - 1 ? ";" : ""));
        }
        return stringBuffer.toString();
    }

    public static String toSemicolonList(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i] + (i < stringArray.length - 1 ? ";" : ""));
        }
        return stringBuffer.toString();
    }

    public static String toSemicolonList(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < vector.size(); ++i) {
            stringBuffer.append(vector.elementAt(i) + (i < vector.size() - 1 ? ";" : ""));
        }
        return stringBuffer.toString();
    }

    public static byte[] fromByteList(String string) {
        Vector vector = Util.parseSemicolons(string, true);
        if (vector.size() > 0) {
            byte[] byArray = new byte[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                byArray[i] = Byte.parseByte((String)vector.elementAt(i));
            }
            return byArray;
        }
        return new byte[0];
    }

    public static long absDiff(long l, long l2) {
        long l3 = l - l2;
        if (l3 < 0L) {
            return l3 * -1L;
        }
        return l3;
    }

    public static String repeat(String string, int n) {
        if (n <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String endWithAPeriod(String string) {
        int n;
        if (string.length() == 0) {
            return string;
        }
        for (n = string.length() - 1; n >= 0 && (Character.isWhitespace(string.charAt(n)) || n > 0 && string.charAt(n) != '^' && string.charAt(n - 1) == '^' && --n >= 0); --n) {
        }
        if (n < 0) {
            return string;
        }
        if (string.charAt(n) == '.' || string.charAt(n) == '!' || string.charAt(n) == '?') {
            return string.trim() + " ";
        }
        return string.substring(0, n + 1) + ". " + string.substring(n + 1).trim();
    }

    public static String startWithAorAn(String string) {
        if (string.length() == 0) {
            return string;
        }
        if (!(string.toUpperCase().startsWith("A ") || string.toUpperCase().startsWith("AN ") || string.toUpperCase().startsWith("THE ") || string.toUpperCase().startsWith("SOME "))) {
            if ("aeiouAEIOU".indexOf(string.charAt(0)) >= 0) {
                return "an " + string;
            }
            return "a " + string;
        }
        return string;
    }

    public static int getParmInt(String string, String string2, int n) {
        int n2 = string.toUpperCase().indexOf(string2.toUpperCase());
        while (n2 >= 0) {
            if (n2 == 0 || !Character.isLetter(string.charAt(n2 - 1))) {
                while (n2 < string.length() && string.charAt(n2) != '=' && !Character.isDigit(string.charAt(n2))) {
                    if (string.charAt(n2) == '+' || string.charAt(n2) == '-') {
                        return n;
                    }
                    ++n2;
                }
                if (n2 < string.length() && string.charAt(n2) == '=') {
                    while (n2 < string.length() && !Character.isDigit(string.charAt(n2))) {
                        ++n2;
                    }
                    if (n2 < string.length()) {
                        string = string.substring(n2);
                        for (n2 = 0; n2 < string.length() && Character.isDigit(string.charAt(n2)); ++n2) {
                        }
                        return Util.s_int(string.substring(0, n2));
                    }
                }
                n2 = -1;
                continue;
            }
            n2 = string.toUpperCase().indexOf(string2.toUpperCase(), n2 + 1);
        }
        return n;
    }

    public static boolean isVowel(char c) {
        return "aeiou".indexOf(Character.toLowerCase(c)) >= 0;
    }

    public static int getParmPlus(String string, String string2) {
        int n = string.toUpperCase().indexOf(string2.toUpperCase());
        while (n >= 0) {
            if (n == 0 || !Character.isLetter(string.charAt(n - 1))) {
                while (n < string.length() && string.charAt(n) != '+' && string.charAt(n) != '-') {
                    if (string.charAt(n) == '=') {
                        return 0;
                    }
                    ++n;
                }
                if (n < string.length()) {
                    char c = string.charAt(n);
                    while (n < string.length() && !Character.isDigit(string.charAt(n))) {
                        ++n;
                    }
                    if (n < string.length()) {
                        string = string.substring(n);
                        for (n = 0; n < string.length() && Character.isDigit(string.charAt(n)); ++n) {
                        }
                        if (c == '+') {
                            return Util.s_int(string.substring(0, n));
                        }
                        return -Util.s_int(string.substring(0, n));
                    }
                }
                n = -1;
                continue;
            }
            n = string.toUpperCase().indexOf(string2.toUpperCase(), n + 1);
        }
        return 0;
    }

    public static double getParmDoublePlus(String string, String string2) {
        int n = string.toUpperCase().indexOf(string2.toUpperCase());
        while (n >= 0) {
            if (n == 0 || !Character.isLetter(string.charAt(n - 1))) {
                while (n < string.length() && string.charAt(n) != '+' && string.charAt(n) != '-') {
                    if (string.charAt(n) == '=') {
                        return 0.0;
                    }
                    ++n;
                }
                if (n < string.length()) {
                    char c = string.charAt(n);
                    while (n < string.length() && !Character.isDigit(string.charAt(n)) && string.charAt(n) != '.') {
                        ++n;
                    }
                    if (n < string.length()) {
                        string = string.substring(n);
                        for (n = 0; n < string.length() && (Character.isDigit(string.charAt(n)) || string.charAt(n) == '.'); ++n) {
                        }
                        if (string.substring(0, n).indexOf(46) < 0) {
                            if (c == '+') {
                                return Util.s_int(string.substring(0, n));
                            }
                            return -Util.s_int(string.substring(0, n));
                        }
                        if (c == '+') {
                            return Util.s_double(string.substring(0, n));
                        }
                        return -Util.s_double(string.substring(0, n));
                    }
                }
                n = -1;
                continue;
            }
            n = string.toUpperCase().indexOf(string2.toUpperCase(), n + 1);
        }
        return 0.0;
    }

    public static double getParmDouble(String string, String string2, double d) {
        int n = string.toUpperCase().indexOf(string2.toUpperCase());
        while (n >= 0) {
            if (n == 0 || !Character.isLetter(string.charAt(n - 1))) {
                while (n < string.length() && string.charAt(n) != '=') {
                    ++n;
                }
                if (n < string.length()) {
                    while (n < string.length() && !Character.isDigit(string.charAt(n)) && string.charAt(n) != '.') {
                        ++n;
                    }
                    if (n < string.length()) {
                        string = string.substring(n);
                        for (n = 0; n < string.length() && (Character.isDigit(string.charAt(n)) || string.charAt(n) == '.'); ++n) {
                        }
                        if (string.substring(0, n).indexOf(46) < 0) {
                            return Util.s_long(string.substring(0, n));
                        }
                        return Util.s_double(string.substring(0, n));
                    }
                }
                n = -1;
                continue;
            }
            n = string.toUpperCase().indexOf(string2.toUpperCase(), n + 1);
        }
        return d;
    }

    public static String getParmStr(String string, String string2, String string3) {
        int n = string.toUpperCase().indexOf(string2.toUpperCase());
        while (n >= 0) {
            if (n == 0 || !Character.isLetter(string.charAt(n - 1))) {
                while (n < string.length() && string.charAt(n) != '=') {
                    if (string.charAt(n) == '+' || string.charAt(n) == '-') {
                        return string3;
                    }
                    ++n;
                }
                if (n < string.length()) {
                    boolean bl = false;
                    while (n < string.length() && !Character.isLetterOrDigit(string.charAt(n))) {
                        if (string.charAt(n) == '\"') {
                            bl = true;
                            ++n;
                            break;
                        }
                        ++n;
                    }
                    if (n < string.length()) {
                        string = string.substring(n);
                        for (n = 0; n < string.length() && (Character.isLetterOrDigit(string.charAt(n)) || bl && string.charAt(n) != '\"'); ++n) {
                        }
                        return string.substring(0, n).trim();
                    }
                }
                n = -1;
                continue;
            }
            n = string.toUpperCase().indexOf(string2.toUpperCase(), n + 1);
        }
        return string3;
    }

    public static String[] toStringArray(Vector vector) {
        if (vector == null || vector.size() == 0) {
            String[] stringArray = new String[]{};
            return stringArray;
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = vector.elementAt(i).toString();
        }
        return stringArray;
    }

    public static long[] toLongArray(Vector vector) {
        if (vector == null || vector.size() == 0) {
            long[] lArray = new long[]{};
            return lArray;
        }
        long[] lArray = new long[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            lArray[i] = Util.s_long(vector.elementAt(i).toString());
        }
        return lArray;
    }

    public static int[] toIntArray(Vector vector) {
        if (vector == null || vector.size() == 0) {
            int[] nArray = new int[]{};
            return nArray;
        }
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            nArray[i] = Util.s_int(vector.elementAt(i).toString());
        }
        return nArray;
    }

    public static String[] toStringArray(HashSet hashSet) {
        if (hashSet == null || hashSet.size() == 0) {
            String[] stringArray = new String[]{};
            return stringArray;
        }
        String[] stringArray = new String[hashSet.size()];
        int n = 0;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            stringArray[n++] = iterator.next().toString();
        }
        return stringArray;
    }

    public static String toStringList(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(", " + stringArray[i]);
        }
        if (stringBuffer.length() == 0) {
            return "";
        }
        return stringBuffer.toString().substring(2);
    }

    public static String toStringList(long[] lArray) {
        if (lArray == null || lArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < lArray.length; ++i) {
            stringBuffer.append(", " + lArray[i]);
        }
        if (stringBuffer.length() == 0) {
            return "";
        }
        return stringBuffer.toString().substring(2);
    }

    public static String toStringList(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(", " + nArray[i]);
        }
        if (stringBuffer.length() == 0) {
            return "";
        }
        return stringBuffer.toString().substring(2);
    }

    public static String toStringList(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < vector.size(); ++i) {
            stringBuffer.append(", " + vector.elementAt(i).toString());
        }
        if (stringBuffer.length() == 0) {
            return "";
        }
        return stringBuffer.toString().substring(2);
    }

    public static String toStringList(HashSet hashSet) {
        if (hashSet == null || hashSet.size() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(", " + iterator.next().toString());
        }
        if (stringBuffer.length() == 0) {
            return "";
        }
        return stringBuffer.toString().substring(2);
    }

    public static Vector makeVector(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                vector.addElement(stringArray[i]);
            }
        }
        return vector;
    }

    public static Vector makeVector() {
        return new Vector();
    }

    public static Vector makeVector(Object object) {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(object);
        return vector;
    }

    public static Vector makeVector(Object object, Object object2) {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(object);
        vector.addElement(object2);
        return vector;
    }

    public static Vector makeVector(Object object, Object object2, Object object3) {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(object);
        vector.addElement(object2);
        vector.addElement(object3);
        return vector;
    }

    public static Vector makeVector(Object object, Object object2, Object object3, Object object4) {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(object);
        vector.addElement(object2);
        vector.addElement(object3);
        vector.addElement(object4);
        return vector;
    }

    public static HashSet makeHashSet() {
        return new HashSet();
    }

    public static HashSet makeHashSet(Object object) {
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(object);
        return hashSet;
    }

    public static HashSet makeHashSet(Object object, Object object2) {
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(object);
        hashSet.add(object2);
        return hashSet;
    }

    public static HashSet makeHashSet(Object object, Object object2, Object object3) {
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(object);
        hashSet.add(object2);
        hashSet.add(object3);
        return hashSet;
    }

    public static HashSet makeHashSet(Object object, Object object2, Object object3, Object object4) {
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(object);
        hashSet.add(object2);
        hashSet.add(object3);
        hashSet.add(object4);
        return hashSet;
    }

    public static String[] toStringArray(Hashtable hashtable) {
        if (hashtable == null || hashtable.size() == 0) {
            String[] stringArray = new String[]{};
            return stringArray;
        }
        String[] stringArray = new String[hashtable.size()];
        int n = 0;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringArray[n] = (String)hashtable.get(string);
            ++n;
        }
        return stringArray;
    }

    public static void addToVector(Vector vector, Vector vector2) {
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                vector2.addElement(vector.elementAt(i));
            }
        }
    }

    public static String toStringList(Hashtable hashtable) {
        if (hashtable == null || hashtable.size() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuffer.append(string + "=" + (String)hashtable.get(string) + "/");
        }
        return stringBuffer.toString();
    }

    public static String replaceAll(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null || string.length() == 0 || string2.length() == 0) {
            return string;
        }
        for (int i = string.length() - 1; i >= 0; --i) {
            if (string.charAt(i) != string2.charAt(0) || !string.substring(i).startsWith(string2)) continue;
            string = string.substring(0, i) + string3 + string.substring(i + string2.length());
        }
        return string;
    }

    public static String replaceAllIgnoreCase(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null || string.length() == 0 || string2.length() == 0) {
            return string;
        }
        for (int i = string.length() - 1; i >= 0; --i) {
            if (Character.toUpperCase(string.charAt(i)) != Character.toUpperCase(string2.charAt(0)) || !string.substring(i).toUpperCase().startsWith(string2.toUpperCase())) continue;
            boolean bl = Character.isUpperCase(string.charAt(i));
            if (string3.length() > 0) {
                string3 = (bl ? Character.toUpperCase(string3.charAt(0)) : Character.toLowerCase(string3.charAt(0))) + string3.substring(1);
            }
            string = string.substring(0, i) + string3 + string.substring(i + string2.length());
        }
        return string;
    }

    public static String replaceFirst(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null || string.length() == 0 || string2.length() == 0) {
            return string;
        }
        for (int i = string.length() - 1; i >= 0; --i) {
            if (string.charAt(i) != string2.charAt(0) || !string.substring(i).startsWith(string2)) continue;
            string = string.substring(0, i) + string3 + string.substring(i + string2.length());
            return string;
        }
        return string;
    }

    public static boolean isInteger(String string) {
        if (string.length() == 0) {
            return false;
        }
        if (string.startsWith("-") && string.length() > 1) {
            string = string.substring(1);
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isDouble(String string) {
        if (string.length() == 0) {
            return false;
        }
        if (string.startsWith("-") && string.length() > 1) {
            string = string.substring(1);
        }
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            if (string.charAt(i) == '.') {
                if (bl) {
                    return false;
                }
                bl = true;
                continue;
            }
            return false;
        }
        return bl;
    }

    public static String capitalizeAndLower(String string) {
        return (Character.toUpperCase(string.charAt(0)) + string.substring(1).toLowerCase()).trim();
    }

    public static String capitalizeFirstLetter(String string) {
        return (Character.toUpperCase(string.charAt(0)) + string.substring(1)).trim();
    }

    public static boolean s_bool(String string) {
        return Boolean.valueOf(string);
    }

    public static int s_int(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 0;
        }
        return n;
    }

    public static int s0_int(String string) {
        int n = 0;
        while (string.length() > 0 && string.startsWith("0")) {
            string = string.substring(1);
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 0;
        }
        return n;
    }

    public static String lastWordIn(String string) {
        int n = string.lastIndexOf(32);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static String removeColors(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = -1;
        block5: for (int i = 0; i < stringBuffer.length(); ++i) {
            switch (stringBuffer.charAt(i)) {
                case 'm': {
                    if (n < 0) continue block5;
                    stringBuffer.delete(n, i + 1);
                    n = -1;
                    continue block5;
                }
                case '\u001b': {
                    n = i;
                    continue block5;
                }
                case '^': {
                    if (i + 1 < stringBuffer.length()) {
                        int n2 = i;
                        char c = stringBuffer.charAt(i + 1);
                        if (c == '<' || c == '&') {
                            i += 2;
                            while (i < stringBuffer.length() - 1) {
                                if (c == '<' && (stringBuffer.charAt(i) != '^' || stringBuffer.charAt(i + 1) != '>') || c == '&' && stringBuffer.charAt(i) != ';') {
                                    if (++i < stringBuffer.length() - 1) continue;
                                    i = n2;
                                    stringBuffer.delete(i, i + 2);
                                    --i;
                                    continue block5;
                                }
                                if (c == '<') {
                                    stringBuffer.delete(n2, i + 2);
                                } else {
                                    stringBuffer.delete(n2, i + 1);
                                }
                                i = n2 - 1;
                                continue block5;
                            }
                            continue block5;
                        }
                        stringBuffer.delete(i, i + 2);
                        --i;
                        continue block5;
                    }
                    stringBuffer.delete(i, i + 2);
                    --i;
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String returnTime(long l, long l2) {
        String string = "";
        if (l2 > 0L) {
            string = ", Average=" + l / l2 + "ms";
        }
        if (l < 1000L) {
            return l + "ms" + string;
        }
        long l3 = l / 1000L;
        l -= l3 * 1000L;
        if (l3 < 60L) {
            return l3 + "s " + l + "ms" + string;
        }
        long l4 = l3 / 60L;
        l3 -= l4 * 60L;
        if (l4 < 60L) {
            return l4 + "m " + l3 + "s " + l + "ms" + string;
        }
        long l5 = l4 / 60L;
        l4 -= l5 * 60L;
        if (l5 < 24L) {
            return l5 + "h " + l4 + "m " + l3 + "s " + l + "ms" + string;
        }
        long l6 = l5 / 24L;
        return l6 + "d " + (l5 -= l6 * 24L) + "h " + l4 + "m " + l3 + "s " + l + "ms" + string;
    }

    public static Vector copyVector(Vector vector) {
        Vector vector2 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (e instanceof Vector) {
                vector2.addElement(Util.copyVector((Vector)e));
                continue;
            }
            vector2.addElement(e);
        }
        return vector2;
    }

    public static int numBits(String string) {
        int n = 0;
        boolean bl = false;
        char c = '\u0000';
        int n2 = 0;
        int n3 = 0;
        string = string.trim();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            c = string.charAt(i);
            boolean bl3 = bl2 = Character.isWhitespace(c) || c == ' ' || c == '\t' || c == '\t';
            if (bl2 && bl && (n2 == 39 && n3 != 39 || n2 == 96 && n3 != 96)) {
                bl2 = false;
            }
            if (bl2 && bl) {
                ++n;
                c = '\u0000';
                n3 = 0;
                n2 = 0;
                bl = false;
                continue;
            }
            if (bl2) continue;
            if (!bl) {
                bl = true;
                n2 = c;
                n3 = 0;
                continue;
            }
            n3 = c;
        }
        if (bl) {
            return n + 1;
        }
        return n;
    }

    public static String cleanBit(String string) {
        while (string.startsWith(" ")) {
            string = string.substring(1);
        }
        while (string.endsWith(" ")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((string.startsWith("'") || string.startsWith("`")) && ((string = string.substring(1)).endsWith("'") || string.endsWith("`"))) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String getCleanBit(String string, int n) {
        return Util.cleanBit(Util.getBit(string, n));
    }

    public static String getPastBitClean(String string, int n) {
        return Util.cleanBit(Util.getPastBit(string, n));
    }

    public static String getPastBit(String string, int n) {
        int n2 = 0;
        boolean bl = false;
        string = string.trim();
        String string2 = "";
        char c = '\u0000';
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            c = string.charAt(i);
            boolean bl3 = bl2 = Character.isWhitespace(c) || c == ' ' || c == '\t' || c == '\t';
            if (bl2 && bl && (n4 == 39 && n3 != 39 || n4 == 96 && n3 != 96)) {
                bl2 = false;
            }
            if (bl2 && bl) {
                if (n2 == n) {
                    if (((string = string.substring(i + 1)).trim().startsWith("'") || string.trim().startsWith("`")) && (string.trim().startsWith("'") || string.trim().startsWith("`"))) {
                        string = string.trim().substring(1, string.length() - 1);
                    }
                    return string;
                }
                ++n2;
                bl = false;
                c = '\u0000';
                n3 = 0;
                n4 = 0;
                continue;
            }
            if (bl2) continue;
            if (!bl) {
                string2 = "";
                n4 = c;
                n3 = 0;
                bl = true;
            } else {
                n3 = c;
            }
            string2 = string2 + c;
        }
        return "";
    }

    public static String getBit(String string, int n) {
        int n2 = 0;
        boolean bl = false;
        string = string.trim();
        String string2 = "";
        char c = '\u0000';
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            c = string.charAt(i);
            boolean bl3 = bl2 = Character.isWhitespace(c) || c == ' ' || c == '\t' || c == '\t';
            if (bl2 && bl && (n4 == 39 && n3 != 39 || n4 == 96 && n3 != 96)) {
                bl2 = false;
            }
            if (bl2 && bl) {
                if (n2 == n) {
                    return string2;
                }
                ++n2;
                bl = false;
                c = '\u0000';
                n3 = 0;
                n4 = 0;
                continue;
            }
            if (bl2) continue;
            if (!bl) {
                string2 = "";
                n4 = c;
                n3 = 0;
                bl = true;
            } else {
                n3 = c;
            }
            string2 = string2 + c;
        }
        if (bl) {
            return string2;
        }
        return "";
    }

    public static long s_long(String string) {
        long l = 0L;
        try {
            l = Long.parseLong(string);
        }
        catch (Exception exception) {
            return 0L;
        }
        return l;
    }

    public static double s_double(String string) {
        double d = 0.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            return 0.0;
        }
        return d;
    }

    public static String combine(Vector vector, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (vector != null) {
            for (int i = n; i < n2; ++i) {
                stringBuffer.append((String)vector.elementAt(i) + " ");
            }
        }
        return stringBuffer.toString().trim();
    }

    public static String combineWithQuotes(Vector vector, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (vector != null) {
            for (int i = n; i < n2; ++i) {
                String string = (String)vector.elementAt(i);
                if (string.indexOf(32) >= 0) {
                    string = "\"" + string + "\"";
                }
                stringBuffer.append(string + " ");
            }
        }
        return stringBuffer.toString().trim();
    }

    public static String combineAfterIndexWithQuotes(Vector vector, String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (vector != null) {
            for (int i = 0; i < 0; ++i) {
                String string2 = (String)vector.elementAt(i);
                if (string2.indexOf(32) >= 0) {
                    string2 = "\"" + string2 + "\"";
                }
                stringBuffer.append(string2 + " ");
            }
        }
        return stringBuffer.toString().trim();
    }

    public static String combineWithQuotes(Vector vector, int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (vector != null) {
            for (int i = n; i < vector.size(); ++i) {
                String string = (String)vector.elementAt(i);
                if (string.indexOf(32) >= 0) {
                    string = "\"" + string + "\"";
                }
                stringBuffer.append(string + " ");
            }
        }
        return stringBuffer.toString().trim();
    }

    public static String combine(Vector vector, int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (vector != null) {
            for (int i = n; i < vector.size(); ++i) {
                stringBuffer.append((String)vector.elementAt(i) + " ");
            }
        }
        return stringBuffer.toString().trim();
    }

    public static Vector parse(String string) {
        return Util.parse(string, -1);
    }

    public static Vector paramParse(String string) {
        Vector vector = Util.parse(string);
        for (int i = 0; i < vector.size(); ++i) {
            String string2;
            String string3 = (String)vector.elementAt(i);
            if (string3.startsWith("=") && string3.length() > 1 && i > 0) {
                string2 = (String)vector.elementAt(i - 1);
                vector.setElementAt(string2 + string3, i - 1);
                vector.removeElementAt(i);
                --i;
                continue;
            }
            if (string3.endsWith("=") && string3.length() > 1 && i < vector.size() - 1) {
                string2 = (String)vector.elementAt(i + 1);
                vector.setElementAt(string3 + string2, i);
                vector.removeElementAt(i + 1);
                continue;
            }
            if (!string3.equals("=") || i <= 0 || i >= vector.size() - 1) continue;
            string2 = (String)vector.elementAt(i - 1);
            String string4 = (String)vector.elementAt(i + 1);
            vector.setElementAt(string2 + "=" + string4, i - 1);
            vector.removeElementAt(i);
            vector.removeElementAt(i + 1);
            --i;
        }
        return vector;
    }

    public static Vector parse(String string, int n) {
        Vector<String> vector = new Vector<String>();
        if (string == null) {
            return vector;
        }
        string = string.trim();
        while (!string.equals("")) {
            int n2 = string.indexOf(32);
            int n3 = string.indexOf("\"");
            String string2 = "";
            if (n3 >= 0 && (n3 < n2 || n2 < 0)) {
                int n4 = string.indexOf("\"", n3 + 1);
                if (n4 > n3) {
                    string2 = string.substring(n3 + 1, n4).trim();
                    string = string.substring(n4 + 1).trim();
                } else {
                    string2 = string.substring(n3 + 1).trim();
                    string = "";
                }
            } else if (n2 >= 0) {
                string2 = string.substring(0, n2).trim();
                string = string.substring(n2 + 1).trim();
            } else {
                string2 = string.trim();
                string = "";
            }
            if (string2.equals("")) continue;
            vector.addElement(string2);
            if (n < 0 || vector.size() < n) continue;
            if (string.length() <= 0) break;
            vector.addElement(string);
            break;
        }
        return vector;
    }

    public static String stripBadHTMLTags(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        Vector<Character> vector = new Vector<Character>();
        int n = -1;
        int n2 = -1;
        StringBuffer stringBuffer2 = null;
        String string2 = null;
        block6: while (++n < stringBuffer.length()) {
            switch (stringBuffer.charAt(n)) {
                case '<': {
                    if (vector.size() > 0) continue block6;
                    stringBuffer2 = new StringBuffer("");
                    string2 = null;
                    n2 = n;
                    continue block6;
                }
                case '>': {
                    if (stringBuffer2 != null) {
                        string2 = stringBuffer2.toString();
                    }
                    if (vector.size() == 0 && n2 >= 0 && n - n2 > 0 && string2 != null && string2.trim().equalsIgnoreCase("FONT")) {
                        int n3 = n - n2 + 1;
                        stringBuffer.delete(n2, n + 1);
                        n -= n3;
                    }
                    stringBuffer2 = null;
                    string2 = null;
                    n2 = -1;
                    continue block6;
                }
                case ' ': {
                    if (stringBuffer2 == null) continue block6;
                    string2 = stringBuffer2.toString();
                    stringBuffer2 = null;
                    continue block6;
                }
                case '\"': 
                case '\'': {
                    if (n2 < 0) continue block6;
                    if (vector.size() > 0 && ((Character)vector.lastElement()).charValue() == stringBuffer.charAt(n)) {
                        vector.removeElementAt(vector.size() - 1);
                        continue block6;
                    }
                    vector.addElement(new Character(stringBuffer.charAt(n)));
                    continue block6;
                }
            }
            if (stringBuffer2 == null) continue;
            stringBuffer2.append(stringBuffer.charAt(n));
        }
        return stringBuffer.toString();
    }

    public static Vector parseCommas(String string, boolean bl) {
        Vector<String> vector = new Vector<String>();
        if (string == null || string.length() == 0) {
            return vector;
        }
        int n = string.indexOf(44);
        while (n >= 0) {
            String string2 = string.substring(0, n).trim();
            string = string.substring(n + 1).trim();
            if (!bl || string2.length() > 0) {
                vector.addElement(string2);
            }
            n = string.indexOf(44);
        }
        if (!bl || string.trim().length() > 0) {
            vector.addElement(string.trim());
        }
        return vector;
    }

    public static Vector parsePipes(String string, boolean bl) {
        Vector<String> vector = new Vector<String>();
        if (string == null || string.length() == 0) {
            return vector;
        }
        int n = string.indexOf(124);
        while (n >= 0) {
            String string2 = string.substring(0, n).trim();
            string = string.substring(n + 1).trim();
            if (!bl || string2.length() > 0) {
                vector.addElement(string2);
            }
            n = string.indexOf(124);
        }
        if (!bl || string.trim().length() > 0) {
            vector.addElement(string.trim());
        }
        return vector;
    }

    public static Vector parseSquiggles(String string) {
        Vector<String> vector = new Vector<String>();
        if (string == null || string.length() == 0) {
            return vector;
        }
        int n = string.indexOf(126);
        while (n >= 0) {
            String string2 = string.substring(0, n).trim();
            string = string.substring(n + 1).trim();
            vector.addElement(string2);
            n = string.indexOf(126);
        }
        return vector;
    }

    public static Vector parseSentences(String string) {
        Vector<String> vector = new Vector<String>();
        if (string == null || string.length() == 0) {
            return vector;
        }
        int n = string.indexOf(46);
        while (n >= 0) {
            String string2 = string.substring(0, n + 1);
            string = string.substring(n + 1);
            vector.addElement(string2);
            n = string.indexOf(46);
        }
        return vector;
    }

    public static Vector parseSquiggleDelimited(String string, boolean bl) {
        Vector<String> vector = new Vector<String>();
        if (string == null || string.length() == 0) {
            return vector;
        }
        int n = string.indexOf(126);
        while (n >= 0) {
            String string2 = string.substring(0, n).trim();
            string = string.substring(n + 1).trim();
            if (string2.length() > 0 || !bl) {
                vector.addElement(string2);
            }
            n = string.indexOf(126);
        }
        if (string.length() > 0 || !bl) {
            vector.addElement(string);
        }
        return vector;
    }

    public static Vector parseSemicolons(String string, boolean bl) {
        Vector<String> vector = new Vector<String>();
        if (string == null || string.length() == 0) {
            return vector;
        }
        int n = string.indexOf(59);
        while (n >= 0) {
            String string2 = string.substring(0, n).trim();
            string = string.substring(n + 1).trim();
            if (!bl || string2.length() > 0) {
                vector.addElement(string2);
            }
            n = string.indexOf(59);
        }
        if (!bl || string.trim().length() > 0) {
            vector.addElement(string.trim());
        }
        return vector;
    }

    public static int abs(int n) {
        if (n >= 0) {
            return n;
        }
        return n * -1;
    }

    public static long abs(long l) {
        if (l >= 0L) {
            return l;
        }
        return l * -1L;
    }

    public static Vector parseSpaces(String string, boolean bl) {
        Vector<String> vector = new Vector<String>();
        if (string == null || string.length() == 0) {
            return vector;
        }
        int n = string.indexOf(32);
        while (n >= 0) {
            String string2 = string.substring(0, n).trim();
            string = string.substring(n + 1).trim();
            if (!bl || string2.length() > 0) {
                vector.addElement(string2);
            }
            n = string.indexOf(32);
        }
        if (!bl || string.trim().length() > 0) {
            vector.addElement(string.trim());
        }
        return vector;
    }

    public static int lengthMinusColors(String string) {
        int n = 0;
        block0: for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '^') {
                if (++i + 1 >= string.length()) continue;
                int n2 = i;
                char c = string.charAt(i);
                if (c != '<' && c != '&') continue;
                while (i < string.length() - 1) {
                    if (c == '<' && (string.charAt(i) != '^' || string.charAt(i + 1) != '>') || c == '&' && string.charAt(i) != ';') {
                        if (++i < string.length() - 1) continue;
                        i = n2 + 1;
                        continue block0;
                    }
                    ++i;
                    continue block0;
                }
                continue;
            }
            ++n;
        }
        return n;
    }

    public static String convertToRoman(int n) {
        int n2;
        int n3;
        String string = "";
        String[] stringArray = new String[]{"C", "CC", "CCC", "CD", "D", "DC", "DCC", "DCCC", "CM", "P"};
        String[] stringArray2 = new String[]{"X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC", "C"};
        String[] stringArray3 = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X"};
        if (n > 1000) {
            string = "Y";
            n %= 1000;
        }
        if (n >= 100) {
            n3 = n % 100;
            n2 = (n - n3) / 100;
            if (n2 > 0) {
                string = string + stringArray[n2 - 1];
            }
            n = n3;
        }
        if (n >= 10 && (n2 = (n - (n3 = n % 10)) / 10) > 0) {
            string = string + stringArray2[n2 - 1];
        }
        if ((n %= 10) > 0) {
            string = string + stringArray3[n - 1];
        }
        return string;
    }

    public static String padLeft(String string, int n) {
        int n2 = Util.lengthMinusColors(string);
        if (n2 > n) {
            return Util.removeColors(string).substring(0, n);
        }
        return SPACES.substring(0, n - n2) + string;
    }

    public static String padLeft(String string, String string2, int n) {
        int n2 = Util.lengthMinusColors(string);
        if (n2 > n) {
            return string2 + Util.removeColors(string).substring(0, n);
        }
        return SPACES.substring(0, n - n2) + string2 + string;
    }

    public static String padRight(String string, int n) {
        int n2 = Util.lengthMinusColors(string);
        if (n2 > n) {
            return Util.removeColors(string).substring(0, n);
        }
        return string + SPACES.substring(0, n - n2);
    }

    public static String limit(String string, int n) {
        int n2 = Util.lengthMinusColors(string);
        if (n2 > n) {
            return Util.removeColors(string).substring(0, n);
        }
        return string;
    }

    public static String padRight(String string, String string2, int n) {
        int n2 = Util.lengthMinusColors(string);
        if (n2 > n) {
            return Util.removeColors(string).substring(0, n) + string2;
        }
        return string + string2 + SPACES.substring(0, n - n2);
    }

    public static String padRightPreserve(String string, int n) {
        int n2 = Util.lengthMinusColors(string);
        if (n2 > n) {
            return Util.removeColors(string);
        }
        return string + SPACES.substring(0, n - n2);
    }

    public static String centerPreserve(String string, int n) {
        int n2 = Util.lengthMinusColors(string);
        if (n2 > n) {
            return Util.removeColors(string);
        }
        int n3 = (n - n2) / 2;
        int n4 = n3 + n3 + n2 < n ? n3 + 1 : n3;
        return SPACES.substring(0, n3) + string + SPACES.substring(0, n4);
    }

    public static String padLeftPreserve(String string, int n) {
        int n2 = Util.lengthMinusColors(string);
        if (n2 > n) {
            return Util.removeColors(string);
        }
        return SPACES.substring(0, n - n2) + string;
    }

    public static boolean isNumber(String string) {
        if (string == null) {
            return false;
        }
        if ((string = string.trim()).length() == 0) {
            return false;
        }
        if (string.length() > 1 && string.startsWith("-")) {
            string = string.substring(1);
        }
        for (int i = 0; i < string.length(); ++i) {
            if ("0123456789.,".indexOf(string.charAt(i)) >= 0) continue;
            return false;
        }
        return true;
    }

    public static double div(double d, double d2) {
        return d / d2;
    }

    public static double div(double d, int n) {
        return d / (double)n;
    }

    public static double div(int n, double d) {
        return (double)n / d;
    }

    public static double div(double d, long l) {
        return d / (double)l;
    }

    public static double div(long l, double d) {
        return (double)l / d;
    }

    public static double mul(double d, double d2) {
        return d * d2;
    }

    public static double mul(double d, int n) {
        return d * (double)n;
    }

    public static double mul(int n, double d) {
        return (double)n * d;
    }

    public static double mul(double d, long l) {
        return d * (double)l;
    }

    public static double mul(long l, double d) {
        return (double)l * d;
    }

    public static long mul(long l, long l2) {
        return l * l2;
    }

    public static int mul(int n, int n2) {
        return n * n2;
    }

    public static double div(long l, long l2) {
        return (double)l / (double)l2;
    }

    public static double div(int n, int n2) {
        return (double)n / (double)n2;
    }

    public static int pow(int n, int n2) {
        return (int)Math.round(Math.pow(n, n2));
    }

    public static int squared(int n) {
        return (int)Math.round(Math.pow(n, n));
    }

    public static boolean bset(int n, int n2) {
        return (n & n2) == n2;
    }

    public static boolean bset(long l, long l2) {
        return (l & l2) == l2;
    }

    public static boolean bset(long l, int n) {
        return (l & (long)n) == (long)n;
    }

    public static int setb(int n, int n2) {
        return n | n2;
    }

    public static boolean banyset(int n, int n2) {
        return (n & n2) > 0;
    }

    public static boolean banyset(long l, long l2) {
        return (l & l2) > 0L;
    }

    public static boolean banyset(long l, int n) {
        return (l & (long)n) > 0L;
    }

    public static long setb(long l, int n) {
        return l | (long)n;
    }

    public static long setb(long l, long l2) {
        return l | l2;
    }

    public static int unsetb(int n, int n2) {
        if (Util.bset(n, n2)) {
            n -= n2;
        }
        return n;
    }

    public static long unsetb(long l, long l2) {
        if (Util.bset(l, l2)) {
            l -= l2;
        }
        return l;
    }

    public static long unsetb(long l, int n) {
        if (Util.bset(l, n)) {
            l -= (long)n;
        }
        return l;
    }

    public static boolean isSet(int n, int n2) {
        return (n & Util.pow(2, n2)) == Util.pow(2, n2);
    }

    public static boolean isSet(long l, int n) {
        return (l & (long)Util.pow(2, n)) == (long)Util.pow(2, n);
    }

    public static String sameCase(String string, char c) {
        if (Character.isUpperCase(c)) {
            return string.toUpperCase();
        }
        return string.toLowerCase();
    }

    public static Vector denumerate(Enumeration enumeration) {
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }
}

