package com.planet_ink.coffee_mud.Abilities.Spells;
import com.planet_ink.coffee_mud.core.interfaces.*;
import com.planet_ink.coffee_mud.core.*;
import com.planet_ink.coffee_mud.core.collections.*;
import com.planet_ink.coffee_mud.Abilities.interfaces.*;
import com.planet_ink.coffee_mud.Areas.interfaces.*;
import com.planet_ink.coffee_mud.Behaviors.interfaces.*;
import com.planet_ink.coffee_mud.CharClasses.interfaces.*;
import com.planet_ink.coffee_mud.Commands.interfaces.*;
import com.planet_ink.coffee_mud.Common.interfaces.*;
import com.planet_ink.coffee_mud.Exits.interfaces.*;
import com.planet_ink.coffee_mud.Items.interfaces.*;
import com.planet_ink.coffee_mud.Locales.interfaces.*;
import com.planet_ink.coffee_mud.MOBS.interfaces.*;
import com.planet_ink.coffee_mud.Races.interfaces.*;


import java.util.*;

/* 
   Copyright 2000-2011 Bo Zimmerman

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
@SuppressWarnings("unchecked")
public class Spell_ManaShield extends Spell
{
    public String ID() { return "Spell_ManaShield"; }
    public String name(){return "Mana Shield";}
    public String displayText(){return "(Mana Shield)";}
    public int abstractQuality(){ return Ability.QUALITY_BENEFICIAL_SELF;}
    protected int canAffectCode(){return CAN_MOBS;}
    public int classificationCode(){ return Ability.ACODE_SPELL|Ability.DOMAIN_ABJURATION;}
    protected double protection(){return 0.5;}
    protected String adjective(){return " a";}

    public void unInvoke()
    {
        // undo the affects of this spell
        if((affected==null)||(!(affected instanceof MOB)))
            return;
        MOB mob=(MOB)affected;

        super.unInvoke();

        if(canBeUninvoked())
            if((mob.location()!=null)&&(!mob.amDead()))
                mob.location().show(mob,null,CMMsg.MSG_OK_VISUAL,"The mana shield around <S-NAME> fades.");
    }

    public boolean okMessage(final Environmental myHost, final CMMsg msg)
    {
        if(!super.okMessage(myHost,msg))
            return false;

        if((affected==null)||(!(affected instanceof MOB)))
            return true;

        MOB mob=(MOB)affected;
        if((msg.amITarget(mob))
           &&(msg.targetMinor()==CMMsg.TYP_DAMAGE))
        {
            int recovery=(int)Math.round(CMath.mul((msg.value()),protection()));
            if(recovery>mob.curState().getMana())
                recovery=mob.curState().getMana();
            if(recovery>0)
            {
                msg.setValue(msg.value()-recovery);
                mob.curState().adjMana(-recovery,mob.maxState());
            }
        }
        return true;
    }
    public boolean invoke(MOB mob, Vector commands, Physical givenTarget, boolean auto, int asLevel)
    {
        Physical target=mob;
        if((auto)&&(givenTarget!=null)) target=givenTarget;
        boolean oldOne=false;
		for(final Enumeration<Ability> a=target.effects();a.hasMoreElements();)
		{
			final Ability A=a.nextElement();
            if(A instanceof Spell_ManaShield)
                oldOne=true;
		}
        if(oldOne)
        {
            mob.tell(mob,target,null,"<T-NAME> <T-IS-ARE> already affected by "+name()+".");
            return false;
        }

        if(!super.invoke(mob,commands,givenTarget,auto,asLevel))
            return false;

        boolean success=proficiencyCheck(mob,0,auto);

        if(success)
        {
            // it worked, so build a copy of this ability,
            // and add it to the affects list of the
            // affected MOB.  Then tell everyone else
            // what happened.
            CMMsg msg=CMClass.getMsg(mob,target,this,verbalCastCode(mob,target,auto),auto?"":"^S<S-NAME> invoke(s)"+adjective()+" protective shield.^?");
            if(mob.location().okMessage(mob,msg))
            {
                mob.location().send(mob,msg);
                mob.location().show(mob,target,CMMsg.MSG_OK_VISUAL,CMStrings.capitalizeAndLower(adjective()).trim()+" protective aura of mana surrounds <T-NAME>.");
                beneficialAffect(mob,target,asLevel,0);
            }
        }
        else
            return beneficialWordsFizzle(mob,target,"<S-NAME> attempt(s) to invoke"+adjective()+" protective shield, but mess(es) up.");


        // return whether it worked
        return success;
    }
}
